/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;

public final class SonarVersion {
    static final SonarVersion INSTANCE = new SonarVersion();
    private final String version;
    private final String formatted;
    private final String gitBranch;
    private final String gitCommit;

    SonarVersion() {
        Manifest manifest = SonarVersion.getManifest();
        this.version = manifest.getMainAttributes().getValue("Implementation-Version");
        this.gitBranch = manifest.getMainAttributes().getValue("Git-Branch");
        this.gitCommit = manifest.getMainAttributes().getValue("Git-Commit");
        this.formatted = this.version + " (" + this.gitCommit + ")";
    }

    @NotNull
    private static Manifest getManifest() {
        Manifest manifest;
        block9: {
            String classLocation = "/" + Sonar.class.getName().replace(".", "/") + ".class";
            URL resource = Sonar.class.getResource(classLocation);
            if (resource == null) {
                throw new IllegalStateException("Could not find version information. Is the manifest missing?");
            }
            String classFilePath = resource.toString().replace("\\", "/");
            String archivePath = classFilePath.substring(0, classFilePath.length() - classLocation.length());
            String manifestPath = archivePath + "/META-INF/MANIFEST.MF";
            InputStream stream = new URL(manifestPath).openStream();
            try {
                manifest = new Manifest(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new IllegalStateException(exception);
                }
            }
            stream.close();
        }
        return manifest;
    }

    public String toString() {
        return this.formatted;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public String getGitBranch() {
        return this.gitBranch;
    }

    public String getGitCommit() {
        return this.gitCommit;
    }
}

