/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.config;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.simpleyaml.configuration.MemorySection;
import org.simpleyaml.configuration.file.YamlFile;
import xyz.jonesdev.sonar.api.Sonar;

public final class SimpleYamlConfig {
    private final File file;
    private final YamlFile yaml;

    public SimpleYamlConfig(@NotNull File file) {
        this.file = file;
        this.yaml = new YamlFile(file.getPath());
    }

    private void replaceConfigFile(@NotNull URL defaultData) throws Exception {
        try (InputStream inputStream = defaultData.openStream();){
            Files.copy(inputStream, this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void load(@NotNull URL defaultData) throws Exception {
        boolean exists = this.yaml.exists();
        if (!exists) {
            this.replaceConfigFile(defaultData);
        }
        this.yaml.loadWithComments();
        if (exists) {
            Map values = this.yaml.getValues(true);
            this.replaceConfigFile(defaultData);
            this.yaml.loadWithComments();
            this.yaml.getValues(true).forEach((path, v) -> {
                Object value = values.get(path);
                if (!(value == null || value.equals(v) || v instanceof MemorySection || value instanceof MemorySection)) {
                    this.yaml.set(path, value);
                }
            });
            this.yaml.save();
        }
    }

    public void set(String path, Object v) {
        this.yaml.set(path, v);
    }

    public int getInt(String path) {
        if (!this.yaml.contains(path)) {
            Sonar.get0().getLogger().warn("Could not find {} in {}.", path, this.file.getName());
            return 0;
        }
        return this.yaml.getInt(path);
    }

    public boolean getBoolean(String path) {
        if (!this.yaml.contains(path)) {
            Sonar.get0().getLogger().warn("Could not find {} in {}.", path, this.file.getName());
            return false;
        }
        return this.yaml.getBoolean(path);
    }

    @NotNull
    public String getString(String path) {
        if (!this.yaml.contains(path)) {
            Sonar.get0().getLogger().warn("Could not find {} in {}.", path, this.file.getName());
            return "";
        }
        Object object = this.yaml.get(path);
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalStateException("Invalid entry " + path);
    }

    public List<String> getStringList(String path) {
        if (!this.yaml.contains(path)) {
            Sonar.get0().getLogger().warn("Could not find {} in {}.", path, this.file.getName());
            return new ArrayList<String>(0);
        }
        return this.yaml.getStringList(path);
    }

    public List<Integer> getIntList(String path) {
        if (!this.yaml.contains(path)) {
            Sonar.get0().getLogger().warn("Could not find {} in {}.", path, this.file.getName());
            return new ArrayList<Integer>(0);
        }
        return this.yaml.getIntegerList(path);
    }

    public File getFile() {
        return this.file;
    }

    public YamlFile getYaml() {
        return this.yaml;
    }
}

