/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.database.controller;

import java.io.File;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.config.SonarConfiguration;
import xyz.jonesdev.sonar.api.database.model.VerifiedPlayer;
import xyz.jonesdev.sonar.api.fingerprint.FingerprintingUtil;
import xyz.jonesdev.sonar.libs.libby.LibraryManager;
import xyz.jonesdev.sonar.libs.ormlite.dao.Dao;
import xyz.jonesdev.sonar.libs.ormlite.dao.DaoManager;
import xyz.jonesdev.sonar.libs.ormlite.jdbc.JdbcConnectionSource;
import xyz.jonesdev.sonar.libs.ormlite.stmt.QueryBuilder;
import xyz.jonesdev.sonar.libs.ormlite.support.ConnectionSource;
import xyz.jonesdev.sonar.libs.ormlite.table.TableUtils;

public final class VerifiedPlayerController {
    private final Set<String> cache = Collections.synchronizedSet(new HashSet());
    @Nullable
    private ConnectionSource connectionSource;
    private Dao<VerifiedPlayer, Integer> dao;
    private QueryBuilder<VerifiedPlayer, Integer> queryBuilder;
    @NotNull
    private final SonarConfiguration.Database.Type cachedDatabaseType;
    private final ExecutorService updateService = Executors.newSingleThreadExecutor();
    private int maximumAge;

    public VerifiedPlayerController(@NotNull LibraryManager libraryManager) {
        SonarConfiguration.Database database = Sonar.get0().getConfig().getDatabase();
        this.cachedDatabaseType = database.getType();
        if (this.cachedDatabaseType == SonarConfiguration.Database.Type.NONE) {
            Sonar.get0().getLogger().warn("Configure a database to save verified players.", new Object[0]);
            return;
        }
        if (!this.cachedDatabaseType.isLoaded()) {
            Sonar.get0().getLogger().info("Loading {} driver version {}", this.cachedDatabaseType.getDatabaseType().getDatabaseName(), this.cachedDatabaseType.getDatabaseDriver().getVersion());
            libraryManager.loadLibrary(this.cachedDatabaseType.getDatabaseDriver());
            this.cachedDatabaseType.setLoaded(true);
        }
        try {
            String jdbcURL;
            if (this.cachedDatabaseType == SonarConfiguration.Database.Type.H2) {
                File file = new File(Sonar.get0().getConfig().getPluginFolder(), Sonar.get0().getConfig().getGeneralConfig().getString("database.filename"));
                jdbcURL = String.format(this.cachedDatabaseType.getConnectionString(), file.getAbsolutePath());
            } else {
                jdbcURL = String.format(this.cachedDatabaseType.getConnectionString(), Sonar.get0().getConfig().getGeneralConfig().getString("database.host"), Sonar.get0().getConfig().getGeneralConfig().getInt("database.port"), Sonar.get0().getConfig().getGeneralConfig().getString("database.name"), "?autoReconnect=true");
            }
            this.connectionSource = new JdbcConnectionSource(jdbcURL, Sonar.get0().getConfig().getGeneralConfig().getString("database.username"), Sonar.get0().getConfig().getGeneralConfig().getString("database.password"), this.cachedDatabaseType.getDatabaseType());
            try {
                TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, VerifiedPlayer.class);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.dao = DaoManager.createDao((ConnectionSource)this.connectionSource, VerifiedPlayer.class);
            this.queryBuilder = this.dao.queryBuilder();
            this.maximumAge = database.getMaximumAge();
            this.updateService.execute(() -> {
                if (this.connectionSource != null) {
                    try {
                        this.clearOld(this.maximumAge, false);
                        this.dao.queryForAll().forEach(verifiedPlayer -> this.cache.add(verifiedPlayer.getFingerprint()));
                    }
                    catch (SQLException exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            });
        }
        catch (SQLException exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void close() {
        if (this.connectionSource != null) {
            this.updateService.shutdown();
            try {
                this.connectionSource.close();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            this.connectionSource = null;
        }
    }

    public void clearOld(@Range(from=1L, to=365L) int maximumAge, boolean removeExisting) throws SQLException {
        long timestamp = Instant.now().minus(maximumAge, ChronoUnit.DAYS).getEpochSecond() * 1000L;
        List oldEntries = this.queryBuilder.where().lt("timestamp", (Object)new Timestamp(timestamp)).query();
        if (oldEntries != null && !oldEntries.isEmpty()) {
            for (VerifiedPlayer player : oldEntries) {
                this.dao.delete((Object)player);
                if (!removeExisting) continue;
                this.cache.remove(player.getFingerprint());
            }
            Sonar.get0().getLogger().info("Removed {} database entries older than {} days.", oldEntries.size(), maximumAge);
        }
    }

    public void remove(@NotNull String fingerprint) {
        this.cache.remove(fingerprint);
        if (this.cachedDatabaseType == SonarConfiguration.Database.Type.NONE) {
            return;
        }
        this.updateService.execute(() -> {
            if (this.connectionSource != null) {
                try {
                    List verifiedPlayer = this.queryBuilder.where().eq("fingerprint", (Object)fingerprint).query();
                    if (verifiedPlayer != null) {
                        for (VerifiedPlayer player : verifiedPlayer) {
                            this.dao.delete((Object)player);
                        }
                    }
                }
                catch (SQLException exception) {
                    exception.printStackTrace(System.err);
                }
            }
        });
    }

    public void add(@NotNull String username, @NotNull String hostAddress, long timestamp) {
        String fingerprint = FingerprintingUtil.getFingerprint(username, hostAddress);
        this.add(new VerifiedPlayer(fingerprint, timestamp));
    }

    public void add(@NotNull VerifiedPlayer player) {
        this.cache.add(player.getFingerprint());
        if (this.cachedDatabaseType == SonarConfiguration.Database.Type.NONE) {
            return;
        }
        this.updateService.execute(() -> {
            if (this.connectionSource != null) {
                try {
                    this.dao.createIfNotExists((Object)player);
                }
                catch (SQLException exception) {
                    exception.printStackTrace(System.err);
                }
            }
        });
    }

    public void clearAll() {
        this.cache.clear();
        if (this.connectionSource != null && this.cachedDatabaseType != SonarConfiguration.Database.Type.NONE) {
            try {
                this.dao.deleteBuilder().delete();
            }
            catch (SQLException exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public Set<String> getCache() {
        return this.cache;
    }

    @NotNull
    public SonarConfiguration.Database.Type getCachedDatabaseType() {
        return this.cachedDatabaseType;
    }

    public int getMaximumAge() {
        return this.maximumAge;
    }
}

