/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.event.SonarEvent;
import xyz.jonesdev.sonar.api.event.SonarEventListener;

public final class SonarEventManager {
    public static final SonarEventManager INSTANCE = new SonarEventManager();
    private static final Collection<SonarEventListener> EVENT_LISTENERS = new Vector<SonarEventListener>(0);
    private static final ExecutorService EVENT_SERVICE = Executors.newSingleThreadExecutor();

    @ApiStatus.Internal
    public void publish(@NotNull SonarEvent event) {
        if (EVENT_LISTENERS.isEmpty()) {
            return;
        }
        EVENT_SERVICE.execute(() -> {
            for (SonarEventListener eventListener : EVENT_LISTENERS) {
                try {
                    eventListener.handle(event);
                }
                catch (Throwable throwable) {
                    Sonar.get0().getLogger().error("Could not pass {} to listener: {}", event.getClass().getSimpleName(), throwable);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(SonarEventListener ... listeners) {
        Collection<SonarEventListener> collection = EVENT_LISTENERS;
        synchronized (collection) {
            EVENT_LISTENERS.addAll(Arrays.asList(listeners));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(SonarEventListener ... listeners) {
        Collection<SonarEventListener> collection = EVENT_LISTENERS;
        synchronized (collection) {
            EVENT_LISTENERS.removeAll(Arrays.asList(listeners));
        }
    }

    private SonarEventManager() {
    }
}

