/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.fallback;

import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.config.SonarConfiguration;
import xyz.jonesdev.sonar.api.fallback.FallbackLoginQueue;
import xyz.jonesdev.sonar.api.fallback.captcha.CaptchaGenerator;
import xyz.jonesdev.sonar.api.fallback.ratelimit.Ratelimiter;
import xyz.jonesdev.sonar.libs.caffeine.cache.Cache;

public final class Fallback {
    public static final Fallback INSTANCE = new Fallback();
    private final ConcurrentMap<InetAddress, Integer> online = new ConcurrentHashMap<InetAddress, Integer>(128);
    private final ConcurrentMap<InetAddress, Boolean> connected = new ConcurrentHashMap<InetAddress, Boolean>(256);
    private final FallbackLoginQueue queue = new FallbackLoginQueue();
    private Cache<String, Integer> blacklist;
    private long blacklistTime;
    private CaptchaGenerator captchaGenerator;
    private Ratelimiter<InetAddress> ratelimiter;

    public boolean shouldVerifyNewPlayers() {
        return Fallback.shouldPerform(Sonar.get0().getConfig().getVerification().getTiming());
    }

    public boolean shouldPerformCaptcha() {
        return Fallback.shouldPerform(Sonar.get0().getConfig().getVerification().getMap().getTiming());
    }

    private static boolean shouldPerform(SonarConfiguration.Verification.Timing timing) {
        return timing == SonarConfiguration.Verification.Timing.ALWAYS || timing == SonarConfiguration.Verification.Timing.DURING_ATTACK && Sonar.get0().getAttackTracker().getCurrentAttack() != null;
    }

    public ConcurrentMap<InetAddress, Integer> getOnline() {
        return this.online;
    }

    public ConcurrentMap<InetAddress, Boolean> getConnected() {
        return this.connected;
    }

    public FallbackLoginQueue getQueue() {
        return this.queue;
    }

    public Cache<String, Integer> getBlacklist() {
        return this.blacklist;
    }

    public long getBlacklistTime() {
        return this.blacklistTime;
    }

    public CaptchaGenerator getCaptchaGenerator() {
        return this.captchaGenerator;
    }

    public Ratelimiter<InetAddress> getRatelimiter() {
        return this.ratelimiter;
    }

    private Fallback() {
    }

    public void setBlacklist(Cache<String, Integer> blacklist) {
        this.blacklist = blacklist;
    }

    public void setBlacklistTime(long blacklistTime) {
        this.blacklistTime = blacklistTime;
    }

    public void setCaptchaGenerator(CaptchaGenerator captchaGenerator) {
        this.captchaGenerator = captchaGenerator;
    }

    public void setRatelimiter(Ratelimiter<InetAddress> ratelimiter) {
        this.ratelimiter = ratelimiter;
    }
}

