/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.fallback;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import xyz.jonesdev.sonar.api.Sonar;

public final class FallbackLoginQueue {
    private static final int THREAD_POOL_SIZE = Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors() * 2);
    private static final ExecutorService QUEUE_EXECUTOR = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
    private final ConcurrentMap<InetAddress, Runnable> players = new ConcurrentHashMap<InetAddress, Runnable>(512);

    public void poll() {
        int maxQueuePolls = Math.min(this.players.size(), Sonar.get0().getConfig().getQueue().getMaxQueuePolls());
        if (maxQueuePolls <= 0) {
            return;
        }
        QUEUE_EXECUTOR.execute(() -> {
            Iterator iterator = this.players.entrySet().iterator();
            for (int index = 0; index < maxQueuePolls && iterator.hasNext(); ++index) {
                ((Runnable)iterator.next().getValue()).run();
                iterator.remove();
            }
        });
    }

    public ConcurrentMap<InetAddress, Runnable> getPlayers() {
        return this.players;
    }

    protected FallbackLoginQueue() {
    }
}

