/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.notification;

import java.util.List;
import java.util.UUID;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.notification.NotificationHandler;
import xyz.jonesdev.sonar.api.profiler.SimpleProcessProfiler;
import xyz.jonesdev.sonar.libs.kyori.adventure.audience.Audience;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.Component;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.ComponentLike;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.minimessage.MiniMessage;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import xyz.jonesdev.sonar.libs.kyori.adventure.title.Title;

public final class ChatNotificationHandler
extends NotificationHandler {
    @Override
    public void handleNotification() {
        if (this.subscribers.isEmpty()) {
            return;
        }
        Component notificationTitle = MiniMessage.miniMessage().deserialize((Object)Sonar.get0().getConfig().getMessagesConfig().getString("notifications.title"));
        Component notificationSubtitle = MiniMessage.miniMessage().deserialize((Object)Sonar.get0().getConfig().getMessagesConfig().getString("notifications.subtitle"));
        Title title = Title.title(notificationTitle, notificationSubtitle);
        List<String> chatNotification = Sonar.get0().getConfig().getMessagesConfig().getStringList("notifications.chat");
        Component[] chatNotificationComponents = new Component[chatNotification.size()];
        for (int i = 0; i < chatNotificationComponents.length; ++i) {
            chatNotificationComponents[i] = MiniMessage.miniMessage().deserialize(chatNotification.get(i), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"queued", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getFallback().getQueue().getPlayers().size())), Placeholder.unparsed((String)"verifying", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getFallback().getConnected().size())), Placeholder.unparsed((String)"blacklisted", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getFallback().getBlacklist().estimatedSize())), Placeholder.unparsed((String)"total-joins", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalPlayersJoined())), Placeholder.unparsed((String)"logins-per-second", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getLoginsPerSecond())), Placeholder.unparsed((String)"connections-per-second", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getConnectionsPerSecond())), Placeholder.unparsed((String)"verify-total", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalAttemptedVerifications())), Placeholder.unparsed((String)"verify-success", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalSuccessfulVerifications())), Placeholder.unparsed((String)"verify-failed", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalFailedVerifications())), Placeholder.unparsed((String)"incoming-traffic", (String)Sonar.get0().getStatistics().getPerSecondIncomingBandwidthFormatted()), Placeholder.unparsed((String)"outgoing-traffic", (String)Sonar.get0().getStatistics().getPerSecondOutgoingBandwidthFormatted()), Placeholder.unparsed((String)"incoming-traffic-ttl", (String)SimpleProcessProfiler.formatMemory(Sonar.get0().getStatistics().getTotalIncomingBandwidth())), Placeholder.unparsed((String)"outgoing-traffic-ttl", (String)SimpleProcessProfiler.formatMemory(Sonar.get0().getStatistics().getTotalOutgoingBandwidth())), Placeholder.unparsed((String)"used-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getUsedMemory())), Placeholder.unparsed((String)"free-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getFreeMemory())), Placeholder.unparsed((String)"total-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getTotalMemory())), Placeholder.unparsed((String)"max-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getMaxMemory()))});
        }
        for (UUID subscriber : Sonar.get0().getChatNotificationHandler().getSubscribers()) {
            Audience audience = Sonar.get0().audience(subscriber);
            if (audience == null) continue;
            for (Component component : chatNotificationComponents) {
                audience.sendMessage(component);
            }
            audience.showTitle(title);
        }
    }
}

