/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.bukkit.listener;

import io.netty.channel.Channel;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.bukkit.fallback.FallbackBukkitInjector;
import xyz.jonesdev.sonar.common.util.FakeChannelUtil;

public final class BukkitJoinListener
implements Listener {
    private static MethodHandle _handleMethod;
    private static MethodHandle _listenerField;
    private static MethodHandle _networkManagerField;
    private static MethodHandle _channelField;
    private static boolean initialized;

    @EventHandler(priority=EventPriority.HIGHEST)
    public void handle(@NotNull PlayerJoinEvent event) {
        if (!initialized || event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        try {
            Object handle = _handleMethod.invoke(event.getPlayer());
            Object listener = _listenerField.invoke(handle);
            Object networkManager = _networkManagerField.invoke(listener);
            Channel channel = _channelField.invoke(networkManager);
            if (channel == null || !channel.isActive()) {
                return;
            }
            if (FakeChannelUtil.isFakeChannel(channel)) {
                return;
            }
            if (channel.pipeline().context("sonar-bandwidth-counter") == null) {
                channel.close();
            }
        }
        catch (Throwable throwable) {
            Sonar.get0().getLogger().warn("Couldn't find {}: {}", event.getPlayer().getName(), throwable);
        }
    }

    static {
        try {
            Method handleMethod = FallbackBukkitInjector.getOBCClass("entity.CraftPlayer").getDeclaredMethod("getHandle", new Class[0]);
            Field listenerField = FallbackBukkitInjector.findField(false, handleMethod.getReturnType(), "PlayerConnection", "ServerGamePacketListenerImpl");
            Field networkManagerField = FallbackBukkitInjector.findField(true, listenerField.getType(), "NetworkManager", "Connection");
            Field channelField = FallbackBukkitInjector.getFieldAt(networkManagerField.getType(), Channel.class, 0);
            _handleMethod = MethodHandles.lookup().unreflect(handleMethod);
            _listenerField = MethodHandles.lookup().unreflectGetter(listenerField);
            _networkManagerField = MethodHandles.lookup().unreflectGetter(networkManagerField);
            _channelField = MethodHandles.lookup().unreflectGetter(channelField);
            initialized = true;
        }
        catch (Exception exception) {
            initialized = false;
        }
    }
}

