/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.captcha;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.fallback.captcha.CaptchaGenerator;
import xyz.jonesdev.sonar.captcha.StandardTTFFontProvider;
import xyz.jonesdev.sonar.captcha.filters.CurvesOverlayFilter;
import xyz.jonesdev.sonar.captcha.filters.NoiseOverlayFilter;
import xyz.jonesdev.sonar.libs.jhlabs.image.FBMFilter;
import xyz.jonesdev.sonar.libs.jhlabs.image.SmearFilter;

public final class StandardCaptchaGenerator
implements CaptchaGenerator {
    private static final CurvesOverlayFilter CURVES = new CurvesOverlayFilter(3);
    private static final NoiseOverlayFilter NOISE = new NoiseOverlayFilter(1.0f, 20.0f);
    private static final SmearFilter SMEAR = new SmearFilter();
    private static final FBMFilter FBM = new FBMFilter();
    private static final Random RANDOM = new Random();
    private static final Color[] COLORS = new Color[4];
    private static final float[] COLOR_FRACTIONS = new float[COLORS.length];
    private final int width = 128;
    private final int height = 128;
    @Nullable
    private final File background;
    @Nullable
    private BufferedImage backgroundImage;

    @Override
    @NotNull
    public BufferedImage createImage(char @NotNull [] answer) {
        BufferedImage image = this.createBackgroundImage();
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.applyRandomColorGradient(graphics);
        this.drawCharacters(graphics, answer);
        CURVES.transform(image, graphics);
        NOISE.transform(image);
        graphics.dispose();
        return image;
    }

    @NotNull
    private BufferedImage createBackgroundImage() {
        BufferedImage image = new BufferedImage(128, 128, 5);
        if (this.background == null) {
            return FBM.filter(image, image);
        }
        if (this.backgroundImage == null) {
            try {
                this.backgroundImage = ImageIO.read(this.background);
            }
            catch (IOException exception) {
                throw new IllegalStateException("Could not read background image", exception);
            }
        }
        image.createGraphics().drawImage(this.backgroundImage, 0, 0, Color.WHITE, null);
        return image;
    }

    private void applyRandomColorGradient(@NotNull Graphics2D graphics) {
        for (int i = 0; i < COLORS.length; ++i) {
            float random = 0.9f + RANDOM.nextFloat() * 0.1f;
            StandardCaptchaGenerator.COLORS[i] = Color.getHSBColor(RANDOM.nextFloat(), random * 0.8f, random);
        }
        graphics.setPaint(new RadialGradientPaint(0.0f, 0.0f, 128.0f, COLOR_FRACTIONS, COLORS, MultipleGradientPaint.CycleMethod.REFLECT));
    }

    private void drawCharacters(@NotNull Graphics2D graphics, char @NotNull [] answer) {
        FontRenderContext ctx = graphics.getFontRenderContext();
        GlyphVector[] glyphs = new GlyphVector[answer.length];
        for (int i = 0; i < answer.length; ++i) {
            Font font = StandardTTFFontProvider.FONTS[RANDOM.nextInt(StandardTTFFontProvider.FONTS.length)];
            glyphs[i] = font.createGlyphVector(ctx, String.valueOf(answer[i]));
        }
        double scalingXY = 5.0 - (double)Math.min(answer.length, 5) * 0.65;
        double totalWidth = Arrays.stream(glyphs).mapToDouble(glyph -> glyph.getLogicalBounds().getWidth() * scalingXY - 1.0).sum();
        double beginX = Math.max(Math.min(64.0 - totalWidth / 2.0, totalWidth), 0.0);
        double beginY = 70.25 + scalingXY;
        for (GlyphVector glyph2 : glyphs) {
            AffineTransform transformation = AffineTransform.getTranslateInstance(beginX, beginY);
            double shearXY = Math.sin(beginX + beginY) / 6.0;
            transformation.shear(shearXY, shearXY);
            transformation.scale(scalingXY, scalingXY);
            Shape transformedShape = transformation.createTransformedShape(glyph2.getOutline());
            graphics.fill(transformedShape);
            if (RANDOM.nextFloat() < 0.25f) {
                this.createGlyphOutline(graphics, transformedShape);
            }
            beginX += glyph2.getVisualBounds().getWidth() * scalingXY + 2.0;
            beginY += (double)(-10.0f + RANDOM.nextFloat() * 20.0f);
        }
    }

    private void createGlyphOutline(@NotNull Graphics2D graphics, @NotNull Shape shape) {
        float txy = 1.25f + RANDOM.nextFloat();
        float width = 1.0f + RANDOM.nextFloat();
        AffineTransform translation = AffineTransform.getTranslateInstance(txy, txy);
        Shape strokedShape = new BasicStroke(width).createStrokedShape(shape);
        graphics.fill(translation.createTransformedShape(strokedShape));
    }

    public int getWidth() {
        Objects.requireNonNull(this);
        return 128;
    }

    public int getHeight() {
        Objects.requireNonNull(this);
        return 128;
    }

    @Nullable
    public File getBackground() {
        return this.background;
    }

    @Nullable
    public BufferedImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public StandardCaptchaGenerator(@Nullable File background) {
        this.background = background;
    }

    static {
        FBM.setAmount(0.6f);
        FBM.setScale(15.0f);
        SMEAR.setShape(3);
        SMEAR.setDensity(0.1f);
        SMEAR.setDistance(0);
        SMEAR.setMix(0.35f);
        for (int i = 0; i < COLOR_FRACTIONS.length; ++i) {
            StandardCaptchaGenerator.COLOR_FRACTIONS[i] = (float)i / (float)(COLOR_FRACTIONS.length - 1);
        }
    }
}

