/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.captcha;

import java.awt.Font;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.captcha.StandardCaptchaGenerator;

final class StandardTTFFontProvider {
    private static final String[] FONT_NAMES = new String[]{"Kingthings_Trypewriter_2"};
    static final Font[] FONTS = new Font[FONT_NAMES.length];
    static final int STANDARD_FONT_SIZE = 25;

    private static Font loadFont(@NotNull String path) {
        Font font;
        block8: {
            InputStream inputStream = StandardCaptchaGenerator.class.getResourceAsStream(path);
            try {
                Font customFont = Font.createFont(0, Objects.requireNonNull(inputStream));
                font = customFont.deriveFont(0, 25.0f);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Error loading font. Does your environment support fonts?", exception);
                }
            }
            inputStream.close();
        }
        return font;
    }

    private StandardTTFFontProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (int i = 0; i < FONT_NAMES.length; ++i) {
            StandardTTFFontProvider.FONTS[i] = StandardTTFFontProvider.loadFont(String.format("/assets/fonts/%s.ttf", FONT_NAMES[i]));
        }
    }
}

