/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.boot;

import java.io.File;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.SonarPlatform;
import xyz.jonesdev.sonar.api.SonarSupplier;
import xyz.jonesdev.sonar.api.command.subcommand.SubcommandRegistry;
import xyz.jonesdev.sonar.api.config.SonarConfiguration;
import xyz.jonesdev.sonar.api.database.controller.VerifiedPlayerController;
import xyz.jonesdev.sonar.api.notification.ActionBarNotificationHandler;
import xyz.jonesdev.sonar.api.notification.ChatNotificationHandler;
import xyz.jonesdev.sonar.api.statistics.SonarStatistics;
import xyz.jonesdev.sonar.api.timer.SystemTimer;
import xyz.jonesdev.sonar.common.boot.LibraryLoader;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPreparer;
import xyz.jonesdev.sonar.common.fallback.ratelimit.CaffeineCacheRatelimiter;
import xyz.jonesdev.sonar.common.fallback.ratelimit.NoopCacheRatelimiter;
import xyz.jonesdev.sonar.common.service.ScheduledServiceManager;
import xyz.jonesdev.sonar.common.statistics.GlobalSonarStatistics;
import xyz.jonesdev.sonar.common.subcommand.BlacklistCommand;
import xyz.jonesdev.sonar.common.subcommand.DumpCommand;
import xyz.jonesdev.sonar.common.subcommand.NotifyCommand;
import xyz.jonesdev.sonar.common.subcommand.ReloadCommand;
import xyz.jonesdev.sonar.common.subcommand.StatisticsCommand;
import xyz.jonesdev.sonar.common.subcommand.VerboseCommand;
import xyz.jonesdev.sonar.common.subcommand.VerifiedCommand;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.libs.caffeine.cache.Cache;
import xyz.jonesdev.sonar.libs.caffeine.cache.Caffeine;
import xyz.jonesdev.sonar.libs.caffeine.cache.Ticker;
import xyz.jonesdev.sonar.libs.libby.LibraryManager;
import xyz.jonesdev.sonar.libs.ormlite.logger.Level;
import xyz.jonesdev.sonar.libs.ormlite.logger.Logger;

public abstract class SonarBootstrap<T>
implements Sonar {
    private T plugin;
    private ActionBarNotificationHandler actionBarNotificationHandler;
    private ChatNotificationHandler chatNotificationHandler;
    private SonarConfiguration config;
    private VerifiedPlayerController verifiedPlayerController;
    private final LibraryManager libraryManager;
    private final SonarStatistics statistics;
    private final SonarPlatform platform;
    private final SubcommandRegistry subcommandRegistry;
    private final SystemTimer launchTimer = new SystemTimer();

    public SonarBootstrap(@NotNull T plugin, @NotNull SonarPlatform platform, @NotNull File dataDirectory, @NotNull LibraryManager libraryManager) {
        LibraryLoader.loadLibraries(libraryManager, platform);
        this.libraryManager = libraryManager;
        ProtocolUtil.checkNettyVersion();
        SonarSupplier.set(this);
        this.plugin = plugin;
        this.platform = platform;
        this.statistics = new GlobalSonarStatistics();
        this.actionBarNotificationHandler = new ActionBarNotificationHandler();
        this.chatNotificationHandler = new ChatNotificationHandler();
        this.config = new SonarConfiguration(dataDirectory);
        this.subcommandRegistry = new SubcommandRegistry();
        this.subcommandRegistry.register(new BlacklistCommand(), new VerifiedCommand(), new StatisticsCommand(), new VerboseCommand(), new ReloadCommand(), new DumpCommand(), new NotifyCommand());
        Logger.setGlobalLogLevel((Level)Level.WARNING);
    }

    public final void initialize() {
        this.getLogger().info("Successfully booted in {}s!", this.launchTimer);
        this.getLogger().info("Initializing shared components...", new Object[0]);
        this.reload();
        this.getLogger().info("Successfully initialized components in {}s!", this.launchTimer);
        this.getLogger().info("Enabling all tasks and features...", new Object[0]);
        try {
            this.enable();
            this.getLogger().info("Starting all managed threads...", new Object[0]);
            ScheduledServiceManager.start();
            this.getLogger().info("Done ({}s)!", this.launchTimer);
        }
        catch (Throwable throwable) {
            this.getLogger().error("An error has occurred while launching Sonar: {}", throwable);
            throwable.printStackTrace(System.err);
        }
    }

    public abstract void enable();

    @Override
    public final void reload() {
        boolean blacklistExists;
        this.getConfig().load();
        if (this.verifiedPlayerController != null && this.verifiedPlayerController.getCachedDatabaseType() != this.getConfig().getDatabase().getType()) {
            this.getLogger().warn("Reloading after changing the database type is not recommended as it may cause data loss.", new Object[0]);
        }
        this.getLogger().info("Taking cached snapshots of all packets...", new Object[0]);
        FallbackPreparer.prepare();
        this.getFallback().setRatelimiter((long)this.getConfig().getVerification().getReconnectDelay() > 0L ? new CaffeineCacheRatelimiter(Duration.ofMillis(this.getConfig().getVerification().getReconnectDelay())) : NoopCacheRatelimiter.INSTANCE);
        long blacklistTime = this.getConfig().getVerification().getBlacklistTime();
        boolean bl = blacklistExists = this.getFallback().getBlacklist() != null;
        if (!blacklistExists || this.getFallback().getBlacklistTime() != blacklistTime) {
            this.getFallback().setBlacklist((Cache<String, Integer>)Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.getConfig().getVerification().getBlacklistTime())).ticker(Ticker.systemTicker()).build());
            this.getFallback().setBlacklistTime(blacklistTime);
            if (blacklistExists) {
                this.getLogger().warn("The blacklist has been reset as the duration of entries has changed.", new Object[0]);
            }
        }
        if (this.verifiedPlayerController != null) {
            this.verifiedPlayerController.close();
        }
        this.verifiedPlayerController = new VerifiedPlayerController(this.libraryManager);
    }

    public final void shutdown() {
        this.getLogger().info("Starting shutdown process...", new Object[0]);
        ScheduledServiceManager.stop();
        if (this.verifiedPlayerController != null) {
            this.verifiedPlayerController.close();
        }
        this.disable();
        this.getLogger().info("Successfully shut down. Goodbye!", new Object[0]);
    }

    public abstract void disable();

    public T getPlugin() {
        return this.plugin;
    }

    @Override
    public ActionBarNotificationHandler getActionBarNotificationHandler() {
        return this.actionBarNotificationHandler;
    }

    @Override
    public ChatNotificationHandler getChatNotificationHandler() {
        return this.chatNotificationHandler;
    }

    @Override
    public SonarConfiguration getConfig() {
        return this.config;
    }

    @Override
    public VerifiedPlayerController getVerifiedPlayerController() {
        return this.verifiedPlayerController;
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    @Override
    public SonarStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public SonarPlatform getPlatform() {
        return this.platform;
    }

    @Override
    public SubcommandRegistry getSubcommandRegistry() {
        return this.subcommandRegistry;
    }

    @Override
    public SystemTimer getLaunchTimer() {
        return this.launchTimer;
    }

    public SonarBootstrap(LibraryManager libraryManager, SonarStatistics statistics, SonarPlatform platform, SubcommandRegistry subcommandRegistry) {
        this.libraryManager = libraryManager;
        this.statistics = statistics;
        this.platform = platform;
        this.subcommandRegistry = subcommandRegistry;
    }

    @Override
    public void setActionBarNotificationHandler(ActionBarNotificationHandler actionBarNotificationHandler) {
        this.actionBarNotificationHandler = actionBarNotificationHandler;
    }

    @Override
    public void setChatNotificationHandler(ChatNotificationHandler chatNotificationHandler) {
        this.chatNotificationHandler = chatNotificationHandler;
    }
}

