/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import java.net.InetAddress;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.common.statistics.GlobalSonarStatistics;

public final class FallbackInboundHandler
extends ChannelInboundHandlerAdapter {
    private final Consumer<ChannelPipeline> sonarPipelineInjector;
    private InetAddress inetAddress;

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        GlobalSonarStatistics.countConnection();
        ctx.fireChannelActive();
        this.sonarPipelineInjector.accept(ctx.pipeline());
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
        if (this.inetAddress != null) {
            Sonar.get0().getFallback().getQueue().getPlayers().compute(this.inetAddress, (ignored, action) -> {
                if (action == null) {
                    Sonar.get0().getFallback().getConnected().compute(this.inetAddress, (__, v) -> {
                        if (v == null) {
                            Sonar.get0().getFallback().getOnline().compute(this.inetAddress, (ignored1, count) -> count == null || count <= 1 ? null : Integer.valueOf(count - 1));
                        }
                        return null;
                    });
                }
                return null;
            });
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
    }

    public FallbackInboundHandler(Consumer<ChannelPipeline> sonarPipelineInjector) {
        this.sonarPipelineInjector = sonarPipelineInjector;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }
}

