/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetAddress;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.event.impl.UserVerifyJoinEvent;
import xyz.jonesdev.sonar.api.fallback.FallbackUser;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.api.timer.SystemTimer;
import xyz.jonesdev.sonar.common.fallback.netty.FallbackTailExceptionsHandler;
import xyz.jonesdev.sonar.common.fallback.netty.FallbackVarInt21FrameDecoder;
import xyz.jonesdev.sonar.common.fallback.netty.FallbackVarIntLengthEncoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketDecoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketEncoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketRegistry;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPreparer;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.DisconnectPacket;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackPreJoinHandler;
import xyz.jonesdev.sonar.common.statistics.GlobalSonarStatistics;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.Component;

public final class FallbackUserWrapper
implements FallbackUser {
    private final Channel channel;
    private final InetAddress inetAddress;
    private final ProtocolVersion protocolVersion;
    private final String fingerprint;
    private final String username;
    private final boolean geyser;
    private final SystemTimer loginTimer;
    private boolean forceCaptcha;

    public FallbackUserWrapper(@NotNull ChannelHandlerContext ctx, @NotNull InetAddress inetAddress, @NotNull ProtocolVersion protocolVersion, @NotNull String username, @NotNull String fingerprint, boolean geyser) {
        this.channel = ctx.channel();
        this.inetAddress = inetAddress;
        this.protocolVersion = protocolVersion;
        this.username = username;
        this.fingerprint = fingerprint;
        this.geyser = geyser;
        this.loginTimer = new SystemTimer();
        ++GlobalSonarStatistics.totalAttemptedVerifications;
        if (Sonar.get0().getConfig().getVerification().isLogConnections() && (Sonar.get0().getAttackTracker().getCurrentAttack() == null || Sonar.get0().getConfig().getVerification().isLogDuringAttack())) {
            Sonar.get0().getLogger().info(Sonar.get0().getConfig().getMessagesConfig().getString("verification.logs.connection").replace("<username>", username).replace("<ip>", Sonar.get0().getConfig().formatAddress(inetAddress)).replace("<protocol>", protocolVersion.getName()), new Object[0]);
        }
        Sonar.get0().getEventManager().publish(new UserVerifyJoinEvent(this));
        this.channel.eventLoop().execute(() -> {
            if (!this.channel.isActive()) {
                return;
            }
            if (this.channel.pipeline().context("sonar-frame-encoder") != null) {
                this.channel.close();
                return;
            }
            Sonar.get0().getFallback().getConnected().compute(inetAddress, (__, v) -> true);
            FallbackPacketEncoder newEncoder = new FallbackPacketEncoder(protocolVersion);
            this.channel.pipeline().addFirst("sonar-frame-encoder", (ChannelHandler)FallbackVarIntLengthEncoder.INSTANCE);
            this.channel.pipeline().addLast("sonar-packet-encoder", (ChannelHandler)newEncoder);
            FallbackPacketDecoder newDecoder = new FallbackPacketDecoder(protocolVersion);
            this.channel.pipeline().addFirst("sonar-frame-decoder", (ChannelHandler)new FallbackVarInt21FrameDecoder());
            this.channel.pipeline().addLast("sonar-packet-decoder", (ChannelHandler)newDecoder);
            newDecoder.updateRegistry(FallbackPacketRegistry.LOGIN);
            newEncoder.updateRegistry(FallbackPacketRegistry.LOGIN);
            this.write(FallbackPreparer.loginSuccess);
            if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                newDecoder.updateRegistry(FallbackPacketRegistry.GAME);
                newEncoder.updateRegistry(FallbackPacketRegistry.GAME);
            }
            newDecoder.setListener(new FallbackPreJoinHandler(this));
            this.channel.pipeline().addLast("sonar-exception-tail", (ChannelHandler)FallbackTailExceptionsHandler.INSTANCE);
        });
    }

    @Override
    public void disconnect(@NotNull Component reason) {
        FallbackPacketEncoder encoder = (FallbackPacketEncoder)this.channel.pipeline().get(FallbackPacketEncoder.class);
        boolean duringLogin = encoder != null && encoder.getPacketRegistry() == FallbackPacketRegistry.LOGIN;
        ProtocolUtil.closeWith(this.channel, this.protocolVersion, new DisconnectPacket(reason, duringLogin));
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isGeyser() {
        return this.geyser;
    }

    @Override
    public SystemTimer getLoginTimer() {
        return this.loginTimer;
    }

    @Override
    public boolean isForceCaptcha() {
        return this.forceCaptcha;
    }

    public String toString() {
        return "FallbackUserWrapper(inetAddress=" + String.valueOf(this.getInetAddress()) + ", protocolVersion=" + String.valueOf((Object)this.getProtocolVersion()) + ", geyser=" + this.isGeyser() + ")";
    }

    @Override
    public void setForceCaptcha(boolean forceCaptcha) {
        this.forceCaptcha = forceCaptcha;
    }
}

