/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

@ChannelHandler.Sharable
public final class FallbackVarIntLengthEncoder
extends MessageToMessageEncoder<ByteBuf> {
    public static final FallbackVarIntLengthEncoder INSTANCE = new FallbackVarIntLengthEncoder();

    protected void encode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf byteBuf, @NotNull List<Object> out) throws Exception {
        int readableBytes = byteBuf.readableBytes();
        int length = ProtocolUtil.varIntBytes(readableBytes);
        ByteBuf lenBuf = ctx.alloc().buffer(length);
        ProtocolUtil.writeVarInt(lenBuf, readableBytes);
        out.add(lenBuf);
        out.add(byteBuf.retain());
    }
}

