/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol;

import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.event.impl.CaptchaGenerationEndEvent;
import xyz.jonesdev.sonar.api.timer.SystemTimer;
import xyz.jonesdev.sonar.common.fallback.protocol.map.MapCaptchaInfo;
import xyz.jonesdev.sonar.common.fallback.protocol.map.MapColorPalette;

public final class CaptchaPreparer {
    private static final ExecutorService PREPARATION_SERVICE = Executors.newSingleThreadExecutor();
    private static final Random RANDOM = new Random();
    private static MapCaptchaInfo[] cached;
    private static int preparedAmount;

    public static void prepare() {
        if (cached != null && preparedAmount != cached.length) {
            return;
        }
        SystemTimer timer = new SystemTimer();
        Sonar.get0().getLogger().info("Asynchronously preparing CAPTCHA answers...", new Object[0]);
        Sonar.get0().getLogger().info("Players will be able to join even if the preparation isn't finished", new Object[0]);
        int precomputeAmount = Sonar.get0().getConfig().getVerification().getMap().getPrecomputeAmount();
        char[] alphabet = Sonar.get0().getConfig().getVerification().getMap().getAlphabet().toCharArray();
        preparedAmount = 0;
        cached = new MapCaptchaInfo[precomputeAmount];
        PREPARATION_SERVICE.execute(() -> {
            preparedAmount = 0;
            while (preparedAmount < precomputeAmount) {
                char[] answer = new char[3 + RANDOM.nextInt(2)];
                for (int j = 0; j < answer.length; ++j) {
                    answer[j] = alphabet[RANDOM.nextInt(alphabet.length)];
                }
                BufferedImage image = Sonar.get0().getFallback().getCaptchaGenerator().createImage(answer);
                CaptchaPreparer.cached[CaptchaPreparer.preparedAmount++] = new MapCaptchaInfo(new String(answer), MapColorPalette.imageToBuffer(image));
            }
            Sonar.get0().getLogger().info("Finished preparing {} CAPTCHA answers ({}s)!", preparedAmount, timer);
            Sonar.get0().getEventManager().publish(new CaptchaGenerationEndEvent(timer, preparedAmount));
        });
    }

    public static boolean isCaptchaAvailable() {
        return preparedAmount > 0 && cached != null && cached[0] != null;
    }

    public static MapCaptchaInfo getRandomCaptcha() {
        return cached[RANDOM.nextInt(preparedAmount)];
    }

    private CaptchaPreparer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

