/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketListener;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketRegistry;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPreparer;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

public final class FallbackPacketDecoder
extends ChannelInboundHandlerAdapter {
    private final ProtocolVersion protocolVersion;
    private FallbackPacketRegistry.ProtocolRegistry registry;
    private FallbackPacketListener listener;
    private int totalPacketsSent;

    public void updateRegistry(@NotNull FallbackPacketRegistry registry) {
        this.registry = registry.getProtocolRegistry(FallbackPacketRegistry.Direction.SERVERBOUND, this.protocolVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)msg;
            try {
                if (!ctx.channel().isActive() || !byteBuf.isReadable()) {
                    return;
                }
                if (++this.totalPacketsSent > FallbackPreparer.maxTotalPacketsSent) {
                    throw ProtocolUtil.DEBUG ? new DecoderException("Sent too many packets") : QuietDecoderException.INSTANCE;
                }
                int packetId = ProtocolUtil.readVarInt(byteBuf);
                FallbackPacket packet = this.registry.createPacket(packetId);
                if (packet == null) {
                    return;
                }
                this.checkPacketSize(byteBuf.readableBytes(), packet);
                try {
                    packet.decode(byteBuf, this.protocolVersion);
                }
                catch (Throwable throwable) {
                    throw ProtocolUtil.DEBUG ? new DecoderException(throwable) : QuietDecoderException.INSTANCE;
                }
                if (byteBuf.isReadable()) {
                    throw ProtocolUtil.DEBUG ? new DecoderException("Could not read packet to end (" + byteBuf.readableBytes() + " bytes left)") : QuietDecoderException.INSTANCE;
                }
                if (this.listener != null) {
                    this.listener.handle(packet);
                    ctx.fireChannelRead((Object)packet);
                }
            }
            finally {
                byteBuf.release();
            }
        }
    }

    private void checkPacketSize(int packetSize, @NotNull FallbackPacket packet) throws Exception {
        int expectedMaxLen = packet.expectedMaxLength(this.protocolVersion);
        if (expectedMaxLen != -1 && packetSize > expectedMaxLen) {
            throw ProtocolUtil.DEBUG ? new DecoderException("Packet too large: " + packetSize + " max: " + expectedMaxLen) : QuietDecoderException.INSTANCE;
        }
        int expectedMinLen = packet.expectedMinLength(this.protocolVersion);
        if (expectedMinLen != -1 && packetSize < expectedMinLen) {
            throw ProtocolUtil.DEBUG ? new DecoderException("Packet too small: " + packetSize + " min: " + expectedMinLen) : QuietDecoderException.INSTANCE;
        }
    }

    public FallbackPacketDecoder(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setListener(FallbackPacketListener listener) {
        this.listener = listener;
    }
}

