/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

public final class FallbackPacketSnapshot
implements FallbackPacket {
    private final IntObjectMap<Integer> mappings = new IntObjectHashMap(ProtocolVersion.ID_TO_PROTOCOL_CONSTANT.size());
    private final IntObjectMap<byte[]> cachedBytes = new IntObjectHashMap(ProtocolVersion.ID_TO_PROTOCOL_CONSTANT.size());
    private final Class<? extends FallbackPacket> originalPacketClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FallbackPacketSnapshot(@NotNull FallbackPacket originalPacket) {
        this.originalPacketClass = originalPacket.getClass();
        IntObjectHashMap hashedData = new IntObjectHashMap(ProtocolVersion.ID_TO_PROTOCOL_CONSTANT.size());
        for (ProtocolVersion protocolVersion : ProtocolVersion.ID_TO_PROTOCOL_CONSTANT.values()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                try {
                    originalPacket.encode(byteBuf, protocolVersion);
                }
                catch (Throwable throwable) {
                    Sonar.get0().getLogger().error("Could not encode packet {} for version {}: {}", new Object[]{originalPacket, protocolVersion, throwable});
                    byteBuf.release();
                    break;
                }
                Integer protocol = protocolVersion.getProtocol();
                Integer hash = byteBuf.hashCode();
                Integer hashed = (Integer)hashedData.getOrDefault((Object)hash, (Object)-1);
                if (hashed != -1) {
                    this.mappings.put((Object)protocol, (Object)hashed);
                    continue;
                }
                hashedData.put((Object)hash, (Object)protocol);
                this.mappings.put((Object)protocol, (Object)protocol);
                byte[] bytes = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(bytes);
                this.cachedBytes.put((Object)protocol, (Object)bytes);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        Integer hash = (Integer)this.mappings.get(protocolVersion.getProtocol());
        if (hash == null) {
            throw ProtocolUtil.DEBUG ? new EncoderException("Unable to find hash") : QuietDecoderException.INSTANCE;
        }
        byte[] bytes = (byte[])this.cachedBytes.get((Object)hash);
        if (bytes == null) {
            throw ProtocolUtil.DEBUG ? new EncoderException("Unable to find cached packet") : QuietDecoderException.INSTANCE;
        }
        byteBuf.writeBytes(bytes);
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Class<? extends FallbackPacket> getOriginalPacketClass() {
        return this.originalPacketClass;
    }
}

