/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.handshake;

import io.netty.buffer.ByteBuf;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class HandshakePacket
implements FallbackPacket {
    private int protocolVersionId;
    private String hostname;
    private int port;
    private int intent;
    private static final String FORGE_TOKEN = "\u0000FML\u0000";
    private static final int MAXIMUM_HOSTNAME_LENGTH = 255 + "\u0000FML\u0000".length() + 1;
    public static final int STATUS = 1;
    public static final int LOGIN = 2;
    public static final int TRANSFER = 3;

    @Override
    public void encode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        this.protocolVersionId = ProtocolUtil.readVarInt(byteBuf);
        this.hostname = ProtocolUtil.readString(byteBuf, MAXIMUM_HOSTNAME_LENGTH);
        this.port = byteBuf.readUnsignedShort();
        this.intent = ProtocolUtil.readVarInt(byteBuf);
    }

    public int getProtocolVersionId() {
        return this.protocolVersionId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getIntent() {
        return this.intent;
    }

    public String toString() {
        return "HandshakePacket(protocolVersionId=" + this.getProtocolVersionId() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ")";
    }
}

