/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.login;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

public final class LoginStartPacket
implements FallbackPacket {
    private String username;
    @Nullable
    private UUID uuid;

    @Override
    public void encode(ByteBuf byteBuf, ProtocolVersion protocolVersion) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) {
        this.username = ProtocolUtil.readString(byteBuf, 16);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19)) {
            if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_19_3) && byteBuf.readBoolean()) {
                long now;
                long expiry = byteBuf.readLong();
                if (expiry < (now = System.currentTimeMillis())) {
                    throw ProtocolUtil.DEBUG ? new DecoderException("Bad expiry: " + expiry) : QuietDecoderException.INSTANCE;
                }
                byte[] key = ProtocolUtil.readByteArray(byteBuf);
                if (key.length == 0) {
                    throw ProtocolUtil.DEBUG ? new DecoderException("Empty key") : QuietDecoderException.INSTANCE;
                }
                byte[] signature = ProtocolUtil.readByteArray(byteBuf, 4096);
                if (signature.length == 0) {
                    throw ProtocolUtil.DEBUG ? new DecoderException("Empty signature") : QuietDecoderException.INSTANCE;
                }
            }
            if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19_1) && (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20_2) || byteBuf.readBoolean())) {
                this.uuid = ProtocolUtil.readUUID(byteBuf);
            }
        }
    }

    public String getUsername() {
        return this.username;
    }

    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    public String toString() {
        return "LoginStartPacket(username=" + this.getUsername() + ", uuid=" + String.valueOf(this.getUuid()) + ")";
    }

    public LoginStartPacket() {
    }

    public LoginStartPacket(String username, @Nullable UUID uuid) {
        this.username = username;
        this.uuid = uuid;
    }
}

