/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.login;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.FastUuidSansHyphens;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class LoginSuccessPacket
implements FallbackPacket {
    private UUID uuid;
    private String username;
    private boolean strictErrorHandling;

    @Override
    public void encode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_16)) {
            ProtocolUtil.writeUUID(byteBuf, this.uuid);
        } else if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_7_6)) {
            ProtocolUtil.writeString(byteBuf, this.uuid.toString());
        } else {
            ProtocolUtil.writeString(byteBuf, FastUuidSansHyphens.toString(this.uuid));
        }
        ProtocolUtil.writeString(byteBuf, this.username);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19)) {
            ProtocolUtil.writeVarInt(byteBuf, 0);
        }
        if (protocolVersion.equals((Object)ProtocolVersion.MINECRAFT_1_20_5) || protocolVersion.equals((Object)ProtocolVersion.MINECRAFT_1_21)) {
            byteBuf.writeBoolean(this.strictErrorHandling);
        }
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isStrictErrorHandling() {
        return this.strictErrorHandling;
    }

    public String toString() {
        return "LoginSuccessPacket(uuid=" + String.valueOf(this.getUuid()) + ", username=" + this.getUsername() + ", strictErrorHandling=" + this.isStrictErrorHandling() + ")";
    }

    public LoginSuccessPacket() {
    }

    public LoginSuccessPacket(UUID uuid, String username, boolean strictErrorHandling) {
        this.uuid = uuid;
        this.username = username;
        this.strictErrorHandling = strictErrorHandling;
    }
}

