/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.BinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.CompoundBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.LongArrayBinaryTag;

public final class ChunkDataPacket
implements FallbackPacket {
    private int sectionX;
    private int sectionZ;

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        byteBuf.writeInt(this.sectionX);
        byteBuf.writeInt(this.sectionZ);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_17)) {
            if (protocolVersion.lessThanOrEquals(ProtocolVersion.MINECRAFT_1_17_1)) {
                ProtocolUtil.writeVarInt(byteBuf, 0);
            }
        } else {
            byteBuf.writeBoolean(true);
            if (protocolVersion.inBetween(ProtocolVersion.MINECRAFT_1_16, ProtocolVersion.MINECRAFT_1_16_1)) {
                byteBuf.writeBoolean(true);
            }
            if (protocolVersion.greaterThan(ProtocolVersion.MINECRAFT_1_8)) {
                ProtocolUtil.writeVarInt(byteBuf, 0);
            } else {
                byteBuf.writeShort(1);
            }
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_14)) {
            int i;
            if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_5)) {
                ProtocolUtil.writeVarInt(byteBuf, 1);
                ProtocolUtil.writeVarInt(byteBuf, 4);
                ProtocolUtil.writeVarInt(byteBuf, 37);
                for (i = 0; i < 37; ++i) {
                    byteBuf.writeLong(0L);
                }
            } else {
                long[] motionBlockingData = new long[protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_18) ? 36 : 37];
                CompoundBinaryTag motionBlockingTag = ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("MOTION_BLOCKING", (BinaryTag)LongArrayBinaryTag.longArrayBinaryTag((long[])motionBlockingData))).build();
                CompoundBinaryTag rootTag = ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("root", (BinaryTag)motionBlockingTag)).build();
                ProtocolUtil.writeBinaryTag(byteBuf, protocolVersion, rootTag);
            }
            if (protocolVersion.inBetween(ProtocolVersion.MINECRAFT_1_15, ProtocolVersion.MINECRAFT_1_17_1)) {
                if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_16_2)) {
                    ProtocolUtil.writeVarInt(byteBuf, 1024);
                    for (i = 0; i < 1024; ++i) {
                        ProtocolUtil.writeVarInt(byteBuf, 1);
                    }
                } else {
                    for (i = 0; i < 1024; ++i) {
                        byteBuf.writeInt(0);
                    }
                }
            }
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            byteBuf.writeInt(0);
            byteBuf.writeBytes(new byte[2]);
        } else if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_13)) {
            ProtocolUtil.writeVarInt(byteBuf, 0);
        } else if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_15)) {
            ProtocolUtil.writeByteArray(byteBuf, new byte[1024]);
        } else if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_18)) {
            ProtocolUtil.writeVarInt(byteBuf, 0);
        } else {
            byte[] byArray;
            if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_21_5)) {
                byte[] byArray2 = new byte[8];
                byArray2[0] = 0;
                byArray2[1] = 0;
                byArray2[2] = 0;
                byArray2[3] = 0;
                byArray2[4] = 0;
                byArray2[5] = 0;
                byArray2[6] = 1;
                byArray = byArray2;
                byArray2[7] = 0;
            } else {
                byte[] byArray3 = new byte[6];
                byArray3[0] = 0;
                byArray3[1] = 0;
                byArray3[2] = 0;
                byArray3[3] = 0;
                byArray3[4] = 0;
                byArray = byArray3;
                byArray3[5] = 1;
            }
            byte[] sectionData = byArray;
            int count = 24;
            ProtocolUtil.writeVarInt(byteBuf, sectionData.length * count);
            for (int i = 0; i < count; ++i) {
                byteBuf.writeBytes(sectionData);
            }
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_9_4)) {
            ProtocolUtil.writeVarInt(byteBuf, 0);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_2)) {
            for (int i = 0; i < 6; ++i) {
                ProtocolUtil.writeVarInt(byteBuf, 0);
            }
        } else if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_18)) {
            byte[] lightData = new byte[]{1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 3, -1, -1, 0, 0};
            byteBuf.ensureWritable(lightData.length);
            if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20)) {
                byteBuf.writeBytes(lightData, 1, lightData.length - 1);
            } else {
                byteBuf.writeBytes(lightData);
            }
        }
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public int getSectionX() {
        return this.sectionX;
    }

    public int getSectionZ() {
        return this.sectionZ;
    }

    public String toString() {
        return "ChunkDataPacket(sectionX=" + this.getSectionX() + ", sectionZ=" + this.getSectionZ() + ")";
    }

    public ChunkDataPacket() {
    }

    public ChunkDataPacket(int sectionX, int sectionZ) {
        this.sectionX = sectionX;
        this.sectionZ = sectionZ;
    }
}

