/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class ClientInformationPacket
implements FallbackPacket {
    private String locale;
    private byte viewDistance;
    private int chatVisibility;
    private boolean chatColors;
    private byte difficulty;
    private short skinParts;
    private int mainHand;
    private boolean chatFilteringEnabled;
    private boolean clientListingAllowed;
    private int particleStatus;

    @Override
    public void encode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        this.locale = ProtocolUtil.readString(byteBuf, 16);
        this.viewDistance = byteBuf.readByte();
        this.chatVisibility = ProtocolUtil.readVarInt(byteBuf);
        this.chatColors = byteBuf.readBoolean();
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.difficulty = byteBuf.readByte();
        }
        this.skinParts = byteBuf.readUnsignedByte();
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_9)) {
            this.mainHand = ProtocolUtil.readVarInt(byteBuf);
            if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_17)) {
                this.chatFilteringEnabled = byteBuf.readBoolean();
                if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_18)) {
                    this.clientListingAllowed = byteBuf.readBoolean();
                    if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_2)) {
                        this.particleStatus = ProtocolUtil.readVarInt(byteBuf);
                    }
                }
            }
        }
    }

    @Override
    public int expectedMinLength(ProtocolVersion protocolVersion) {
        return 2;
    }

    @Override
    public int expectedMaxLength(ProtocolVersion protocolVersion) {
        return 256;
    }

    public String getLocale() {
        return this.locale;
    }

    public byte getViewDistance() {
        return this.viewDistance;
    }

    public int getChatVisibility() {
        return this.chatVisibility;
    }

    public boolean isChatColors() {
        return this.chatColors;
    }

    public byte getDifficulty() {
        return this.difficulty;
    }

    public short getSkinParts() {
        return this.skinParts;
    }

    public int getMainHand() {
        return this.mainHand;
    }

    public boolean isChatFilteringEnabled() {
        return this.chatFilteringEnabled;
    }

    public boolean isClientListingAllowed() {
        return this.clientListingAllowed;
    }

    public int getParticleStatus() {
        return this.particleStatus;
    }

    public String toString() {
        return "ClientInformationPacket(locale=" + this.getLocale() + ", viewDistance=" + this.getViewDistance() + ", chatVisibility=" + this.getChatVisibility() + ", chatColors=" + this.isChatColors() + ", difficulty=" + this.getDifficulty() + ", skinParts=" + this.getSkinParts() + ", mainHand=" + this.getMainHand() + ", chatFilteringEnabled=" + this.isChatFilteringEnabled() + ", clientListingAllowed=" + this.isClientListingAllowed() + ", particleStatus=" + this.getParticleStatus() + ")";
    }

    public ClientInformationPacket() {
    }

    public ClientInformationPacket(String locale, byte viewDistance, int chatVisibility, boolean chatColors, byte difficulty, short skinParts, int mainHand, boolean chatFilteringEnabled, boolean clientListingAllowed, int particleStatus) {
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatVisibility = chatVisibility;
        this.chatColors = chatColors;
        this.difficulty = difficulty;
        this.skinParts = skinParts;
        this.mainHand = mainHand;
        this.chatFilteringEnabled = chatFilteringEnabled;
        this.clientListingAllowed = clientListingAllowed;
        this.particleStatus = particleStatus;
    }
}

