/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.dimension.DimensionRegistry;
import xyz.jonesdev.sonar.common.fallback.protocol.dimension.DimensionType;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.BinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.CompoundBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.ListBinaryTag;

public final class JoinGamePacket
implements FallbackPacket {
    private int entityId;
    private int gamemode;
    private int previousGamemode;
    private int viewDistance;
    private int simulationDistance;
    private int difficulty;
    private int maxPlayers;
    private int portalCooldown;
    private int seaLevel;
    private String[] levelNames;
    private String levelName;
    private String levelType;
    private DimensionType dimension;
    private long partialHashedSeed;
    private boolean hardcore;
    private boolean reducedDebugInfo;
    private boolean showRespawnScreen;
    private boolean debug;
    private boolean flat;
    private boolean limitedCrafting;
    private boolean secureProfile;

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        byteBuf.writeInt(this.entityId);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_16_2)) {
            byteBuf.writeBoolean(this.hardcore);
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            byteBuf.writeByte(this.gamemode);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_16)) {
            if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                byteBuf.writeByte(this.previousGamemode);
            }
            ProtocolUtil.writeStringArray(byteBuf, this.levelNames);
            CompoundBinaryTag codec = JoinGamePacket.getCodec(protocolVersion);
            if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                ProtocolUtil.writeBinaryTag(byteBuf, protocolVersion, codec);
            }
            if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_16_2) && protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_19)) {
                ListBinaryTag dimensions = codec.getCompound("minecraft:dimension_type").getList("value");
                BinaryTag elementTag = ((CompoundBinaryTag)dimensions.get(0)).get("element");
                ProtocolUtil.writeBinaryTag(byteBuf, protocolVersion, Objects.requireNonNull(elementTag));
            } else if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                ProtocolUtil.writeString(byteBuf, this.dimension.getKey());
            }
            if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                ProtocolUtil.writeString(byteBuf, this.levelName);
            }
        } else if (protocolVersion.greaterThan(ProtocolVersion.MINECRAFT_1_9)) {
            byteBuf.writeInt(this.dimension.getLegacyId());
        } else {
            byteBuf.writeByte(this.dimension.getLegacyId());
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_15) && protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            byteBuf.writeLong(this.partialHashedSeed);
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_14)) {
            byteBuf.writeByte(this.difficulty);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_16_2)) {
            ProtocolUtil.writeVarInt(byteBuf, this.maxPlayers);
        } else {
            byteBuf.writeByte(this.maxPlayers);
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_16)) {
            ProtocolUtil.writeString(byteBuf, this.levelType);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_14)) {
            ProtocolUtil.writeVarInt(byteBuf, this.viewDistance);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_18)) {
            ProtocolUtil.writeVarInt(byteBuf, this.simulationDistance);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_8)) {
            byteBuf.writeBoolean(this.reducedDebugInfo);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_15)) {
            byteBuf.writeBoolean(this.showRespawnScreen);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20_2)) {
            byteBuf.writeBoolean(this.limitedCrafting);
            if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20_5)) {
                ProtocolUtil.writeVarInt(byteBuf, this.dimension.getId());
            } else {
                ProtocolUtil.writeString(byteBuf, this.dimension.getKey());
            }
            ProtocolUtil.writeString(byteBuf, this.levelName);
            byteBuf.writeLong(this.partialHashedSeed);
            byteBuf.writeByte(this.gamemode);
            byteBuf.writeByte(this.previousGamemode);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_16)) {
            byteBuf.writeBoolean(this.debug);
            byteBuf.writeBoolean(this.flat);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19)) {
            byteBuf.writeBoolean(false);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20)) {
            ProtocolUtil.writeVarInt(byteBuf, this.portalCooldown);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_2)) {
            ProtocolUtil.writeVarInt(byteBuf, this.seaLevel);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20_5)) {
            byteBuf.writeBoolean(this.secureProfile);
        }
    }

    private static CompoundBinaryTag getCodec(@NotNull ProtocolVersion protocolVersion) {
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20)) {
            return DimensionRegistry.CODEC_1_20;
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19_4)) {
            return DimensionRegistry.CODEC_1_19_4;
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19_1)) {
            return DimensionRegistry.CODEC_1_19_1;
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19)) {
            return DimensionRegistry.CODEC_1_19;
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_18_2)) {
            return DimensionRegistry.CODEC_1_18_2;
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_16_2)) {
            return DimensionRegistry.CODEC_1_16_2;
        }
        return DimensionRegistry.CODEC_1_16;
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getGamemode() {
        return this.gamemode;
    }

    public int getPreviousGamemode() {
        return this.previousGamemode;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public String[] getLevelNames() {
        return this.levelNames;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public DimensionType getDimension() {
        return this.dimension;
    }

    public long getPartialHashedSeed() {
        return this.partialHashedSeed;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public boolean isShowRespawnScreen() {
        return this.showRespawnScreen;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public boolean isLimitedCrafting() {
        return this.limitedCrafting;
    }

    public boolean isSecureProfile() {
        return this.secureProfile;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setGamemode(int gamemode) {
        this.gamemode = gamemode;
    }

    public void setPreviousGamemode(int previousGamemode) {
        this.previousGamemode = previousGamemode;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }

    public void setSimulationDistance(int simulationDistance) {
        this.simulationDistance = simulationDistance;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    public void setSeaLevel(int seaLevel) {
        this.seaLevel = seaLevel;
    }

    public void setLevelNames(String[] levelNames) {
        this.levelNames = levelNames;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public void setDimension(DimensionType dimension) {
        this.dimension = dimension;
    }

    public void setPartialHashedSeed(long partialHashedSeed) {
        this.partialHashedSeed = partialHashedSeed;
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = hardcore;
    }

    public void setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    public void setShowRespawnScreen(boolean showRespawnScreen) {
        this.showRespawnScreen = showRespawnScreen;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    public void setLimitedCrafting(boolean limitedCrafting) {
        this.limitedCrafting = limitedCrafting;
    }

    public void setSecureProfile(boolean secureProfile) {
        this.secureProfile = secureProfile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinGamePacket)) {
            return false;
        }
        JoinGamePacket other = (JoinGamePacket)o;
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getGamemode() != other.getGamemode()) {
            return false;
        }
        if (this.getPreviousGamemode() != other.getPreviousGamemode()) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.getSimulationDistance() != other.getSimulationDistance()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getMaxPlayers() != other.getMaxPlayers()) {
            return false;
        }
        if (this.getPortalCooldown() != other.getPortalCooldown()) {
            return false;
        }
        if (this.getSeaLevel() != other.getSeaLevel()) {
            return false;
        }
        if (this.getPartialHashedSeed() != other.getPartialHashedSeed()) {
            return false;
        }
        if (this.isHardcore() != other.isHardcore()) {
            return false;
        }
        if (this.isReducedDebugInfo() != other.isReducedDebugInfo()) {
            return false;
        }
        if (this.isShowRespawnScreen() != other.isShowRespawnScreen()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        if (this.isLimitedCrafting() != other.isLimitedCrafting()) {
            return false;
        }
        if (this.isSecureProfile() != other.isSecureProfile()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLevelNames(), other.getLevelNames())) {
            return false;
        }
        String this$levelName = this.getLevelName();
        String other$levelName = other.getLevelName();
        if (this$levelName == null ? other$levelName != null : !this$levelName.equals(other$levelName)) {
            return false;
        }
        String this$levelType = this.getLevelType();
        String other$levelType = other.getLevelType();
        if (this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType)) {
            return false;
        }
        DimensionType this$dimension = this.getDimension();
        DimensionType other$dimension = other.getDimension();
        return !(this$dimension == null ? other$dimension != null : !((Object)((Object)this$dimension)).equals((Object)other$dimension));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getGamemode();
        result = result * 59 + this.getPreviousGamemode();
        result = result * 59 + this.getViewDistance();
        result = result * 59 + this.getSimulationDistance();
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getMaxPlayers();
        result = result * 59 + this.getPortalCooldown();
        result = result * 59 + this.getSeaLevel();
        long $partialHashedSeed = this.getPartialHashedSeed();
        result = result * 59 + (int)($partialHashedSeed >>> 32 ^ $partialHashedSeed);
        result = result * 59 + (this.isHardcore() ? 79 : 97);
        result = result * 59 + (this.isReducedDebugInfo() ? 79 : 97);
        result = result * 59 + (this.isShowRespawnScreen() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        result = result * 59 + (this.isLimitedCrafting() ? 79 : 97);
        result = result * 59 + (this.isSecureProfile() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getLevelNames());
        String $levelName = this.getLevelName();
        result = result * 59 + ($levelName == null ? 43 : $levelName.hashCode());
        String $levelType = this.getLevelType();
        result = result * 59 + ($levelType == null ? 43 : $levelType.hashCode());
        DimensionType $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)((Object)$dimension)).hashCode());
        return result;
    }

    public String toString() {
        return "JoinGamePacket(entityId=" + this.getEntityId() + ", gamemode=" + this.getGamemode() + ", previousGamemode=" + this.getPreviousGamemode() + ", viewDistance=" + this.getViewDistance() + ", simulationDistance=" + this.getSimulationDistance() + ", difficulty=" + this.getDifficulty() + ", maxPlayers=" + this.getMaxPlayers() + ", portalCooldown=" + this.getPortalCooldown() + ", seaLevel=" + this.getSeaLevel() + ", levelNames=" + Arrays.deepToString(this.getLevelNames()) + ", levelName=" + this.getLevelName() + ", levelType=" + this.getLevelType() + ", dimension=" + String.valueOf((Object)this.getDimension()) + ", partialHashedSeed=" + this.getPartialHashedSeed() + ", hardcore=" + this.isHardcore() + ", reducedDebugInfo=" + this.isReducedDebugInfo() + ", showRespawnScreen=" + this.isShowRespawnScreen() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ", limitedCrafting=" + this.isLimitedCrafting() + ", secureProfile=" + this.isSecureProfile() + ")";
    }

    public JoinGamePacket() {
    }

    public JoinGamePacket(int entityId, int gamemode, int previousGamemode, int viewDistance, int simulationDistance, int difficulty, int maxPlayers, int portalCooldown, int seaLevel, String[] levelNames, String levelName, String levelType, DimensionType dimension, long partialHashedSeed, boolean hardcore, boolean reducedDebugInfo, boolean showRespawnScreen, boolean debug, boolean flat, boolean limitedCrafting, boolean secureProfile) {
        this.entityId = entityId;
        this.gamemode = gamemode;
        this.previousGamemode = previousGamemode;
        this.viewDistance = viewDistance;
        this.simulationDistance = simulationDistance;
        this.difficulty = difficulty;
        this.maxPlayers = maxPlayers;
        this.portalCooldown = portalCooldown;
        this.seaLevel = seaLevel;
        this.levelNames = levelNames;
        this.levelName = levelName;
        this.levelType = levelType;
        this.dimension = dimension;
        this.partialHashedSeed = partialHashedSeed;
        this.hardcore = hardcore;
        this.reducedDebugInfo = reducedDebugInfo;
        this.showRespawnScreen = showRespawnScreen;
        this.debug = debug;
        this.flat = flat;
        this.limitedCrafting = limitedCrafting;
        this.secureProfile = secureProfile;
    }
}

