/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class KeepAlivePacket
implements FallbackPacket {
    private long id;

    @Override
    public void encode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_12_2)) {
            byteBuf.writeLong(this.id);
        } else if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_8)) {
            ProtocolUtil.writeVarInt(byteBuf, (int)this.id);
        } else {
            byteBuf.writeInt((int)this.id);
        }
    }

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        this.id = protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_12_2) ? byteBuf.readLong() : (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_8) ? (long)ProtocolUtil.readVarInt(byteBuf) : (long)byteBuf.readInt());
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return "KeepAlivePacket(id=" + this.getId() + ")";
    }

    public KeepAlivePacket() {
    }

    public KeepAlivePacket(long id) {
        this.id = id;
    }
}

