/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class RemoveEntitiesPacket
implements FallbackPacket {
    private int entityId;

    @Override
    public void encode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (!protocolVersion.equals((Object)ProtocolVersion.MINECRAFT_1_17)) {
            ProtocolUtil.writeVarInt(byteBuf, 1);
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            byteBuf.writeInt(this.entityId);
        } else {
            ProtocolUtil.writeVarInt(byteBuf, this.entityId);
        }
    }

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String toString() {
        return "RemoveEntitiesPacket(entityId=" + this.getEntityId() + ")";
    }

    public RemoveEntitiesPacket() {
    }

    public RemoveEntitiesPacket(int entityId) {
        this.entityId = entityId;
    }
}

