/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class SetExperiencePacket
implements FallbackPacket {
    private float experienceBar;
    private int level;
    private int totalExperience;

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        byteBuf.writeFloat(this.experienceBar);
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            byteBuf.writeShort(this.level);
            byteBuf.writeShort(this.totalExperience);
            return;
        }
        ProtocolUtil.writeVarInt(byteBuf, this.level);
        ProtocolUtil.writeVarInt(byteBuf, this.totalExperience);
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public float getExperienceBar() {
        return this.experienceBar;
    }

    public int getLevel() {
        return this.level;
    }

    public int getTotalExperience() {
        return this.totalExperience;
    }

    public String toString() {
        return "SetExperiencePacket(experienceBar=" + this.getExperienceBar() + ", level=" + this.getLevel() + ", totalExperience=" + this.getTotalExperience() + ")";
    }

    public SetExperiencePacket() {
    }

    public SetExperiencePacket(float experienceBar, int level, int totalExperience) {
        this.experienceBar = experienceBar;
        this.level = level;
        this.totalExperience = totalExperience;
    }
}

