/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;

public final class SetPlayerOnGround
implements FallbackPacket {
    private boolean onGround;
    private boolean horizontalCollision;

    @Override
    public void encode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(@NotNull ByteBuf byteBuf, ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_2)) {
            short flag = byteBuf.readUnsignedByte();
            this.onGround = (flag & 1) != 0;
            this.horizontalCollision = (flag & 2) != 0;
        } else {
            this.onGround = byteBuf.readBoolean();
        }
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean isHorizontalCollision() {
        return this.horizontalCollision;
    }

    public String toString() {
        return "SetPlayerOnGround(onGround=" + this.isOnGround() + ", horizontalCollision=" + this.isHorizontalCollision() + ")";
    }

    public SetPlayerOnGround() {
    }

    public SetPlayerOnGround(boolean onGround, boolean horizontalCollision) {
        this.onGround = onGround;
        this.horizontalCollision = horizontalCollision;
    }
}

