/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ComponentHolder;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

public final class SystemChatPacket
implements FallbackPacket {
    private static final int DIV_FLOOR = -Math.floorDiv(-20, 8);
    private ComponentHolder componentHolder;
    private String message;

    public SystemChatPacket(@NotNull ComponentHolder componentHolder) {
        this.componentHolder = componentHolder;
    }

    @Override
    public void encode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        this.componentHolder.write(byteBuf, protocolVersion, false);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19_1)) {
            byteBuf.writeBoolean(false);
        } else if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19)) {
            ProtocolUtil.writeVarInt(byteBuf, 1);
        } else if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_8)) {
            byteBuf.writeByte(1);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_16) && protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_19)) {
            ProtocolUtil.writeUUID(byteBuf, UUID.randomUUID());
        }
    }

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        this.message = ProtocolUtil.readString(byteBuf, 256);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19)) {
            byteBuf.readLong();
            if (protocolVersion.lessThanOrEquals(ProtocolVersion.MINECRAFT_1_19_1)) {
                boolean signedPreview;
                long saltLong = byteBuf.readLong();
                byte[] signatureBytes = ProtocolUtil.readByteArray(byteBuf);
                boolean unsigned = false;
                if (saltLong == 0L || signatureBytes.length <= 0) {
                    if ((protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19_1) || saltLong == 0L) && signatureBytes.length == 0) {
                        unsigned = true;
                    } else {
                        throw QuietDecoderException.INSTANCE;
                    }
                }
                if ((signedPreview = byteBuf.readBoolean()) && unsigned) {
                    throw QuietDecoderException.INSTANCE;
                }
                if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19_1)) {
                    int size = ProtocolUtil.readVarInt(byteBuf);
                    if (size < 0 || size > 5) {
                        throw QuietDecoderException.INSTANCE;
                    }
                    for (int i = 0; i < size; ++i) {
                        ProtocolUtil.readUUID(byteBuf);
                        ProtocolUtil.readByteArray(byteBuf);
                    }
                    if (byteBuf.readBoolean()) {
                        ProtocolUtil.readUUID(byteBuf);
                        ProtocolUtil.readByteArray(byteBuf);
                    }
                }
            } else {
                byteBuf.readLong();
                boolean signed = byteBuf.readBoolean();
                if (signed) {
                    byte[] sign = new byte[256];
                    byteBuf.readBytes(sign);
                }
                ProtocolUtil.readVarInt(byteBuf);
                byte[] bytes = new byte[DIV_FLOOR];
                byteBuf.readBytes(bytes);
                if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_5)) {
                    byteBuf.readByte();
                }
            }
        }
    }

    public ComponentHolder getComponentHolder() {
        return this.componentHolder;
    }

    public String getMessage() {
        return this.message;
    }

    public void setComponentHolder(ComponentHolder componentHolder) {
        this.componentHolder = componentHolder;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemChatPacket)) {
            return false;
        }
        SystemChatPacket other = (SystemChatPacket)o;
        ComponentHolder this$componentHolder = this.getComponentHolder();
        ComponentHolder other$componentHolder = other.getComponentHolder();
        if (this$componentHolder == null ? other$componentHolder != null : !this$componentHolder.equals(other$componentHolder)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComponentHolder $componentHolder = this.getComponentHolder();
        result = result * 59 + ($componentHolder == null ? 43 : $componentHolder.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "SystemChatPacket(componentHolder=" + String.valueOf(this.getComponentHolder()) + ", message=" + this.getMessage() + ")";
    }

    public SystemChatPacket() {
    }

    public SystemChatPacket(ComponentHolder componentHolder, String message) {
        this.componentHolder = componentHolder;
        this.message = message;
    }
}

