/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;

public final class TransactionPacket
implements FallbackPacket {
    private int windowId;
    private int transactionId;
    private boolean accepted;

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_17)) {
            this.windowId = byteBuf.readByte();
            this.transactionId = byteBuf.readShort();
            this.accepted = byteBuf.readBoolean();
        } else {
            this.transactionId = byteBuf.readInt();
            this.accepted = true;
        }
    }

    @Override
    public void encode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_17)) {
            byteBuf.writeByte(this.windowId);
            byteBuf.writeShort((int)((short)this.transactionId));
            byteBuf.writeBoolean(this.accepted);
        } else {
            byteBuf.writeInt(this.transactionId);
        }
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public String toString() {
        return "TransactionPacket(windowId=" + this.getWindowId() + ", transactionId=" + this.getTransactionId() + ", accepted=" + this.isAccepted() + ")";
    }

    public TransactionPacket() {
    }

    public TransactionPacket(int windowId, int transactionId, boolean accepted) {
        this.windowId = windowId;
        this.transactionId = transactionId;
        this.accepted = accepted;
    }
}

