/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;

public final class UpdateTimePacket
implements FallbackPacket {
    private long worldAge;
    private long timeOfDay;
    private boolean tickDayTime;

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) {
        byteBuf.writeLong(this.worldAge);
        byteBuf.writeLong(this.timeOfDay);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_2)) {
            byteBuf.writeBoolean(this.tickDayTime);
        }
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public long getWorldAge() {
        return this.worldAge;
    }

    public long getTimeOfDay() {
        return this.timeOfDay;
    }

    public boolean isTickDayTime() {
        return this.tickDayTime;
    }

    public UpdateTimePacket() {
    }

    public UpdateTimePacket(long worldAge, long timeOfDay, boolean tickDayTime) {
        this.worldAge = worldAge;
        this.timeOfDay = timeOfDay;
        this.tickDayTime = tickDayTime;
    }
}

