/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.verification;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.fallback.FallbackUser;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketDecoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketEncoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketRegistry;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPreparer;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.configuration.FinishConfigurationPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.login.LoginAcknowledgedPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.ClientInformationPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.KeepAlivePacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.PluginMessagePacket;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackGravityHandler;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackVerificationHandler;

public final class FallbackPreJoinHandler
extends FallbackVerificationHandler {
    private boolean receivedClientInfo;
    private boolean receivedClientBrand;
    private boolean acknowledgedLogin;
    private int expectedKeepAliveId = FallbackPreparer.PRE_JOIN_KEEP_ALIVE_ID;

    public FallbackPreJoinHandler(@NotNull FallbackUser user) {
        super(user);
        if (user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            if (user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_8)) {
                user.channel().eventLoop().schedule(this::markSuccess, 100L, TimeUnit.MILLISECONDS);
            } else {
                user.write(FallbackPreparer.PRE_JOIN_KEEP_ALIVE);
            }
        }
    }

    @Override
    public void handle(@NotNull FallbackPacket packet) {
        if (packet instanceof KeepAlivePacket) {
            KeepAlivePacket keepAlive = (KeepAlivePacket)packet;
            long keepAliveId = keepAlive.getId();
            this.checkState(keepAliveId == (long)this.expectedKeepAliveId, "expected K ID " + this.expectedKeepAliveId + " but got " + keepAliveId);
            if (this.expectedKeepAliveId != 0) {
                if (this.user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                    this.markSuccess();
                } else {
                    this.markAcknowledged();
                }
                this.expectedKeepAliveId = 0;
            }
        } else if (packet instanceof LoginAcknowledgedPacket) {
            this.checkState(!this.acknowledgedLogin, "sent duplicate login ack");
            this.updateEncoderDecoderState(FallbackPacketRegistry.CONFIG);
            this.user.write(FallbackPreparer.PRE_JOIN_KEEP_ALIVE);
        } else if (packet instanceof FinishConfigurationPacket) {
            this.updateEncoderDecoderState(FallbackPacketRegistry.GAME);
            if (!this.user.isGeyser()) {
                this.validateClientInformation();
            }
            this.markSuccess();
        } else if (packet instanceof ClientInformationPacket) {
            ClientInformationPacket clientInformation = (ClientInformationPacket)packet;
            if (!this.user.isGeyser()) {
                this.checkState(clientInformation.getViewDistance() >= 2, "view distance: " + clientInformation.getViewDistance());
            }
            this.receivedClientInfo = true;
        } else if (packet instanceof PluginMessagePacket) {
            PluginMessagePacket pluginMessage = (PluginMessagePacket)packet;
            boolean usingModernChannel = pluginMessage.getChannel().equals("minecraft:brand");
            boolean usingLegacyChannel = pluginMessage.getChannel().equals("MC|Brand");
            if (!usingModernChannel && !usingLegacyChannel) {
                return;
            }
            if (Sonar.get0().getConfig().getVerification().getBrand().isEnabled()) {
                this.checkState(!this.receivedClientBrand, "sent duplicate client brand");
                this.validateClientBrand(pluginMessage.getData());
            }
            this.receivedClientBrand = true;
        }
    }

    private void markAcknowledged() {
        this.acknowledgedLogin = true;
        for (FallbackPacket packet : FallbackPreparer.getRegistryPackets(this.user.getProtocolVersion())) {
            this.user.delayedWrite(packet);
        }
        this.user.delayedWrite(FinishConfigurationPacket.INSTANCE);
        this.user.channel().flush();
    }

    private void markSuccess() {
        if (this.user.channel().isActive()) {
            if (!Sonar.get0().getConfig().getVerification().getValidNameRegex().matcher(this.user.getUsername()).matches()) {
                this.user.disconnect(Sonar.get0().getConfig().getVerification().getInvalidUsername());
                return;
            }
            FallbackGravityHandler gravityHandler = new FallbackGravityHandler(this.user, this);
            ((FallbackPacketDecoder)this.user.channel().pipeline().get(FallbackPacketDecoder.class)).setListener(gravityHandler);
        }
    }

    void validateClientInformation() {
        this.checkState(this.receivedClientInfo, "didn't send client settings");
        this.checkState(this.receivedClientBrand, "didn't send client brand");
    }

    private void updateEncoderDecoderState(@NotNull FallbackPacketRegistry registry) {
        ((FallbackPacketDecoder)this.user.channel().pipeline().get(FallbackPacketDecoder.class)).updateRegistry(registry);
        ((FallbackPacketEncoder)this.user.channel().pipeline().get(FallbackPacketEncoder.class)).updateRegistry(registry);
    }

    private void validateClientBrand(byte @NotNull [] data) {
        this.checkState(data.length > 1, "client brand is too short");
        this.checkState(data.length < Sonar.get0().getConfig().getVerification().getBrand().getMaxLength(), "client brand contains too much data: " + data.length);
        String brand = new String(data, StandardCharsets.UTF_8);
        if (this.user.getProtocolVersion().greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_8) && brand.length() > 1) {
            brand = brand.substring(1);
        }
        Pattern pattern = Sonar.get0().getConfig().getVerification().getBrand().getValidRegex();
        this.checkState(pattern.matcher(brand).matches(), "client brand does not match pattern: " + brand);
    }
}

