/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.verification;

import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.fallback.FallbackUser;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketDecoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPreparer;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.AnimationPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.EntityAnimationPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetHeldItemPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.TransactionPacket;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackCaptchaHandler;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackVehicleHandler;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackVerificationHandler;

public final class FallbackProtocolHandler
extends FallbackVerificationHandler {
    private boolean waitingSwingArm;
    private boolean waitingSlotConfirm;
    private boolean waitingTransaction;
    private short expectedTransactionId;
    private int currentClientSlotId;
    private int expectedSlotId = -1;

    public FallbackProtocolHandler(@NotNull FallbackUser user) {
        super(user);
        this.sendTransaction();
    }

    @Override
    public void handle(@NotNull FallbackPacket packet) {
        if (packet instanceof TransactionPacket) {
            TransactionPacket transaction = (TransactionPacket)packet;
            this.checkState(this.waitingTransaction, "unexpected transaction: " + transaction.getTransactionId());
            this.checkState(transaction.getWindowId() == 0, "wrong window: " + transaction.getWindowId());
            this.checkState(transaction.isAccepted(), "didn't accept transaction");
            long transactionId = transaction.getTransactionId();
            this.checkState(transactionId == (long)this.expectedTransactionId, "expected T ID " + this.expectedTransactionId + ", but got " + transactionId);
            if (this.user.isGeyser()) {
                this.markSuccess();
            } else if (this.waitingSlotConfirm) {
                this.waitingSlotConfirm = false;
                this.expectedSlotId = -1;
                if (this.user.isGeyser()) {
                    this.markSuccess();
                } else {
                    this.sendArmAnimation();
                }
            } else {
                this.sendSetHeldItem();
            }
            this.waitingTransaction = false;
        } else if (packet instanceof SetHeldItemPacket) {
            SetHeldItemPacket heldItemPacket = (SetHeldItemPacket)packet;
            int slotId = heldItemPacket.getSlot();
            this.checkState(slotId >= 0 && slotId <= 8, "slot out of range: " + slotId);
            this.checkState(slotId != this.currentClientSlotId, "duplicate slot: " + slotId);
            if (this.expectedSlotId != -1 && slotId == this.expectedSlotId && !this.waitingSlotConfirm) {
                this.sendTransaction();
                this.waitingSlotConfirm = true;
            }
            this.currentClientSlotId = slotId;
        } else if (packet instanceof AnimationPacket && this.waitingSwingArm) {
            AnimationPacket animationPacket = (AnimationPacket)packet;
            if (this.user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_8)) {
                this.checkState(animationPacket.getEntityId() == FallbackPreparer.PLAYER_ENTITY_ID, "invalid entity ID " + animationPacket.getEntityId());
                if (animationPacket.getType() == AnimationPacket.LegacyAnimationType.SWING_ARM) {
                    this.markSuccess();
                    this.waitingSwingArm = false;
                }
            } else {
                this.checkState(animationPacket.getHand() == 0, "invalid hand " + animationPacket.getHand());
                this.markSuccess();
                this.waitingSwingArm = false;
            }
        }
    }

    private void sendTransaction() {
        this.expectedTransactionId = (short)(-RANDOM.nextInt(Short.MAX_VALUE));
        this.user.write(new TransactionPacket(0, this.expectedTransactionId, false));
        this.waitingTransaction = true;
    }

    private void sendSetHeldItem() {
        this.user.delayedWrite(FallbackPreparer.INVALID_HELD_ITEM_SLOT);
        this.expectedSlotId = (this.currentClientSlotId + 1 + RANDOM.nextInt(7)) % 8;
        SetHeldItemPacket heldItemPacket = new SetHeldItemPacket(this.expectedSlotId);
        this.user.delayedWrite(heldItemPacket);
        this.user.delayedWrite(heldItemPacket);
        this.user.channel().flush();
    }

    private void sendArmAnimation() {
        this.user.write(new EntityAnimationPacket(FallbackPreparer.PLAYER_ENTITY_ID, EntityAnimationPacket.Type.SWING_MAIN_ARM));
        this.waitingSwingArm = true;
    }

    private void markSuccess() {
        if (!this.user.isGeyser() && Sonar.get0().getConfig().getVerification().getVehicle().isEnabled()) {
            ((FallbackPacketDecoder)this.user.channel().pipeline().get(FallbackPacketDecoder.class)).setListener(new FallbackVehicleHandler(this.user));
        } else if (this.user.isForceCaptcha() || Sonar.get0().getFallback().shouldPerformCaptcha()) {
            ((FallbackPacketDecoder)this.user.channel().pipeline().get(FallbackPacketDecoder.class)).setListener(new FallbackCaptchaHandler(this.user));
        } else {
            this.finishVerification();
        }
    }
}

