/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.libs.libby.classloader;

import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;
import xyz.jonesdev.sonar.libs.libby.Library;
import xyz.jonesdev.sonar.libs.libby.LibraryManager;
import xyz.jonesdev.sonar.libs.libby.Util;
import xyz.jonesdev.sonar.libs.libby.classloader.IsolatedClassLoader;
import xyz.jonesdev.sonar.libs.libby.logging.Logger;

public abstract class ClassLoaderHelper {
    public static final String SYSTEM_PROPERTY_DISABLE_UNSAFE = "libby.classloaders.unsafeDisabled";
    public static final String SYSTEM_PROPERTY_DISABLE_JAVA_AGENT = "libby.classloaders.javaAgentDisabled";
    public static final String ENV_VAR_DISABLE_UNSAFE = "LIBBY_CLASSLOADERS_UNSAFE_DISABLED";
    public static final String ENV_VAR_DISABLE_JAVA_AGENT = "LIBBY_CLASSLOADERS_JAVA_AGENT_DISABLED";
    private static final String BYTE_BUDDY_AGENT_CLASS = Util.replaceWithDots("net{}bytebuddy{}agent{}ByteBuddyAgent");
    private static final Method getModuleMethod;
    private static final Method addOpensMethod;
    private static final Method getNameMethod;
    private static final Unsafe theUnsafe;
    private static volatile Instrumentation cachedInstrumentation;
    protected final ClassLoader classLoader;

    public ClassLoaderHelper(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
    }

    public abstract void addToClasspath(@NotNull URL var1);

    public void addToClasspath(@NotNull Path path) {
        try {
            this.addToClasspath(Objects.requireNonNull(path, "path").toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void setMethodAccessible(LibraryManager libraryManager, Method method, String methodSignature, Consumer<MethodHandle> methodHandleConsumer, Consumer<Instrumentation> instrumentationConsumer) {
        if (Modifier.isPublic(method.getModifiers())) {
            return;
        }
        try {
            ClassLoaderHelper.openModule(method.getDeclaringClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method.setAccessible(true);
            return;
        }
        catch (Exception e) {
            Exception javaAgentException;
            Exception unsafeException;
            block20: {
                block19: {
                    this.handleInaccessibleObjectException(e, methodSignature);
                    unsafeException = null;
                    if (theUnsafe != null && this.canUseUnsafe()) {
                        MethodHandle methodHandle;
                        try {
                            methodHandle = this.getPrivilegedMethodHandle(method).bindTo(this.classLoader);
                        }
                        catch (Exception e2) {
                            unsafeException = e2;
                            break block19;
                        }
                        methodHandleConsumer.accept(methodHandle);
                        return;
                    }
                }
                javaAgentException = null;
                if (this.canUseJavaAgent()) {
                    Instrumentation instrumentation;
                    try {
                        instrumentation = this.initInstrumentation(libraryManager);
                    }
                    catch (Exception e3) {
                        javaAgentException = e3;
                        break block20;
                    }
                    try {
                        instrumentationConsumer.accept(instrumentation);
                        return;
                    }
                    catch (Exception e4) {
                        this.handleInaccessibleObjectException(e4, methodSignature);
                    }
                }
            }
            Logger logger = libraryManager.getLogger();
            if (unsafeException != null) {
                logger.error("Cannot set accessible " + methodSignature + " using unsafe", unsafeException);
            }
            if (javaAgentException != null) {
                logger.error("Cannot set accessible " + methodSignature + " using java agent", javaAgentException);
            }
            String packageName = method.getDeclaringClass().getPackage().getName();
            String moduleName = null;
            try {
                moduleName = (String)getNameMethod.invoke(getModuleMethod.invoke(method.getDeclaringClass(), new Object[0]), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (moduleName != null) {
                logger.error("Cannot set accessible " + methodSignature + ", if you are using Java 9+ try to add the following option to your java command: --add-opens " + moduleName + "/" + packageName + "=ALL-UNNAMED");
            } else {
                logger.error("Cannot set accessible " + methodSignature);
            }
            throw new RuntimeException("Cannot set accessible " + methodSignature);
        }
    }

    private void handleInaccessibleObjectException(Exception exception, String methodSignature) {
        if (!exception.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
            throw new RuntimeException("Cannot set accessible " + methodSignature, exception);
        }
    }

    protected static void openModule(Class<?> toOpen) throws Exception {
        Object urlClassLoaderModule = getModuleMethod.invoke(toOpen, new Object[0]);
        Object thisModule = getModuleMethod.invoke(ClassLoaderHelper.class, new Object[0]);
        addOpensMethod.invoke(urlClassLoaderModule, toOpen.getPackage().getName(), thisModule);
    }

    protected MethodHandle getPrivilegedMethodHandle(Method method) {
        for (Field trustedLookup : MethodHandles.Lookup.class.getDeclaredFields()) {
            if (trustedLookup.getType() != MethodHandles.Lookup.class || !Modifier.isStatic(trustedLookup.getModifiers()) || trustedLookup.isSynthetic()) continue;
            try {
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)theUnsafe.getObject(theUnsafe.staticFieldBase(trustedLookup), theUnsafe.staticFieldOffset(trustedLookup));
                return lookup.unreflect(method);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Cannot get privileged method handle.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Instrumentation initInstrumentation(LibraryManager libraryManager) throws Exception {
        Instrumentation instr = cachedInstrumentation;
        if (instr != null) {
            return instr;
        }
        IsolatedClassLoader isolatedClassLoader = new IsolatedClassLoader(new URL[0]);
        try {
            Instrumentation instrumentation;
            isolatedClassLoader.addPath(libraryManager.downloadLibrary(Library.builder().groupId("net{}bytebuddy").artifactId("byte-buddy-agent").version("1.12.1").checksumFromBase64("mcCtBT9cljUEniB5ESpPDYZMfVxEs1JRPllOiWTP+bM=").repository("https://repo1.maven.org/maven2/").build()));
            Class<?> byteBuddyAgent = isolatedClassLoader.loadClass(BYTE_BUDDY_AGENT_CLASS);
            cachedInstrumentation = instrumentation = (Instrumentation)byteBuddyAgent.getMethod("install", new Class[0]).invoke(null, new Object[0]);
            Instrumentation instrumentation2 = instrumentation;
            return instrumentation2;
        }
        finally {
            try {
                isolatedClassLoader.close();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean canUseUnsafe() {
        return !Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_DISABLE_UNSAFE)) && !Boolean.parseBoolean(System.getenv(ENV_VAR_DISABLE_UNSAFE));
    }

    protected boolean canUseJavaAgent() {
        return !Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_DISABLE_JAVA_AGENT)) && !Boolean.parseBoolean(System.getenv(ENV_VAR_DISABLE_JAVA_AGENT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Method getModule = null;
        Method addOpens = null;
        Method getName = null;
        try {
            Class<?> moduleClass = Class.forName("java.lang.Module");
            getModule = Class.class.getMethod("getModule", new Class[0]);
            addOpens = moduleClass.getMethod("addOpens", String.class, moduleClass);
            getName = moduleClass.getMethod("getName", new Class[0]);
        }
        catch (Exception exception) {
        }
        finally {
            getModuleMethod = getModule;
            addOpensMethod = addOpens;
            getNameMethod = getName;
        }
        Unsafe unsafe = null;
        for (Field f : Unsafe.class.getDeclaredFields()) {
            try {
                if (f.getType() != Unsafe.class || !Modifier.isStatic(f.getModifiers())) continue;
                f.setAccessible(true);
                unsafe = (Unsafe)f.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        theUnsafe = unsafe;
    }
}

