/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.command.InvocationSource;
import xyz.jonesdev.sonar.api.command.subcommand.Subcommand;
import xyz.jonesdev.sonar.api.update.UpdateChecker;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.Component;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.ComponentLike;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.event.ClickEvent;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.format.StyleBuilderApplicable;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.minimessage.MiniMessage;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.minimessage.tag.Tag;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public interface SonarCommand {
    public static final Map<Integer, List<String>> TAB_SUGGESTIONS = new LinkedHashMap<Integer, List<String>>();

    default public void handle(@NotNull InvocationSource source, String @NotNull [] args) {
        if (source.isPlayer() && !source.getPermissionFunction().test("sonar.command")) {
            if (Sonar.get0().getConfig().getNoPermission() != null) {
                source.sendMessage(Sonar.get0().getConfig().getNoPermission());
            }
            return;
        }
        Optional<Subcommand> subcommand = Optional.empty();
        if (args.length > 0) {
            subcommand = Sonar.get0().getSubcommandRegistry().getSubcommands().stream().filter(sub -> sub.getInfo().name().equalsIgnoreCase(args[0]) || Arrays.stream(sub.getInfo().aliases()).anyMatch(alias -> alias.equalsIgnoreCase(args[0]))).findFirst();
        }
        subcommand.ifPresentOrElse(command -> {
            if (!command.getInfo().onlyConsole() && !source.getPermissionFunction().test(command.getPermission())) {
                source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.subcommand-no-permission"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"permission", (String)command.getPermission())}));
                return;
            }
            command.invoke(source, args);
        }, () -> {
            UpdateChecker.CheckResult checkResult = UpdateChecker.getLastCheckResult();
            Component version = Component.text(Sonar.get0().getVersion().getFormatted());
            if (checkResult.getConfigKey() != null) {
                version = version.append(MiniMessage.miniMessage().deserialize((Object)Sonar.get0().getConfig().getMessagesConfig().getString("commands.main." + checkResult.getConfigKey())));
            }
            source.sendMessage(MiniMessage.miniMessage().deserialize(String.join((CharSequence)"<newline>", Sonar.get0().getConfig().getMessagesConfig().getStringList("commands.main.header")), new TagResolver[]{Placeholder.component((String)"version", (ComponentLike)version), Placeholder.unparsed((String)"platform", (String)Sonar.get0().getPlatform().getDisplayName()), Placeholder.unparsed((String)"copyright-year", (String)String.valueOf(Calendar.getInstance().get(1)))}));
            Component yes = MiniMessage.miniMessage().deserialize((Object)Sonar.get0().getConfig().getMessagesConfig().getString("commands.main.tick"));
            Component no = MiniMessage.miniMessage().deserialize((Object)Sonar.get0().getConfig().getMessagesConfig().getString("commands.main.cross"));
            Sonar.get0().getSubcommandRegistry().getSubcommands().forEach(command -> source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.main.subcommands"), new TagResolver[]{TagResolver.resolver((String)"suggest-subcommand", (queue, context) -> Tag.styling((StyleBuilderApplicable[])new StyleBuilderApplicable[]{ClickEvent.suggestCommand("/sonar " + command.getInfo().name())})), Placeholder.unparsed((String)"subcommand", (String)command.getInfo().name()), Placeholder.unparsed((String)"description", (String)command.getDescription()), Placeholder.unparsed((String)"permission", (String)command.getPermission()), Placeholder.unparsed((String)"aliases", (String)command.getAliases()), Placeholder.component((String)"only-players", (ComponentLike)(command.getInfo().onlyPlayers() ? yes : no)), Placeholder.component((String)"only-console", (ComponentLike)(command.getInfo().onlyConsole() ? yes : no))})));
        });
    }

    public static void prepareCachedTabSuggestions() {
        if (TAB_SUGGESTIONS.isEmpty()) {
            ArrayList<String> subcommandsAndAliases = new ArrayList<String>();
            for (Subcommand subcommand : Sonar.get0().getSubcommandRegistry().getSubcommands()) {
                subcommandsAndAliases.add(subcommand.getInfo().name());
                List<String> arguments = Arrays.asList(subcommand.getInfo().arguments());
                TAB_SUGGESTIONS.put(subcommand.getInfo().name().hashCode(), arguments);
                for (String alias : subcommand.getInfo().aliases()) {
                    subcommandsAndAliases.add(alias);
                    TAB_SUGGESTIONS.put(alias.hashCode(), arguments);
                }
            }
            TAB_SUGGESTIONS.put(-1, subcommandsAndAliases);
        }
    }

    default public List<String> getCachedTabSuggestions(String @NotNull [] arguments) {
        if (arguments.length <= 2) {
            int subcommandHash = arguments.length <= 1 ? -1 : arguments[0].toLowerCase().hashCode();
            return TAB_SUGGESTIONS.getOrDefault(subcommandHash, Collections.emptyList());
        }
        return Collections.emptyList();
    }
}

