/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.command.SonarCommand;
import xyz.jonesdev.sonar.api.config.Language;
import xyz.jonesdev.sonar.api.config.SimpleYamlConfig;
import xyz.jonesdev.sonar.api.database.ormlite.H2DatabaseTypeAdapter;
import xyz.jonesdev.sonar.api.database.ormlite.MariaDbDatabaseTypeAdapter;
import xyz.jonesdev.sonar.api.database.ormlite.MysqlDatabaseTypeAdapter;
import xyz.jonesdev.sonar.api.database.ormlite.PostgresDatabaseTypeAdapter;
import xyz.jonesdev.sonar.api.webhook.DiscordWebhook;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.Component;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.ComponentLike;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.minimessage.MiniMessage;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import xyz.jonesdev.sonar.libs.libby.Library;
import xyz.jonesdev.sonar.libs.ormlite.db.DatabaseType;

public final class SonarConfiguration {
    private final SimpleYamlConfig generalConfig;
    private final SimpleYamlConfig messagesConfig;
    private final SimpleYamlConfig webhookConfig;
    private final File languageFile;
    private final File pluginFolder;
    private Language language;
    private static final Language DEFAULT_FALLBACK_LANGUAGE = Language.EN;
    private final Queue queue = new Queue();
    private final Verification verification = new Verification();
    private final Database database = new Database();
    private final Webhook webhook = new Webhook();
    private Component prefix;
    private String supportUrl;
    private Component header;
    private Component footer;
    private Component noPermission;
    private boolean logPlayerAddresses;
    private int maxOnlinePerIp;
    private int minPlayersForAttack;
    private int minAttackDuration;
    private int minAttackThreshold;
    private int attackCooldownDelay;
    private Component tooManyOnlinePerIp;
    private List<String> verboseAnimation;

    public SonarConfiguration(@NotNull File pluginFolder) {
        this.pluginFolder = pluginFolder;
        this.messagesConfig = new SimpleYamlConfig(new File(pluginFolder, "messages.yml"));
        this.generalConfig = new SimpleYamlConfig(new File(pluginFolder, "config.yml"));
        this.webhookConfig = new SimpleYamlConfig(new File(pluginFolder, "webhook.yml"));
        this.languageFile = new File(pluginFolder, "language.properties");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Language getPreferredLanguage() {
        if (!this.languageFile.exists()) {
            URL defaultLanguageFile = Sonar.class.getResource("/assets/language.properties");
            if (defaultLanguageFile == null) {
                Sonar.get0().getLogger().error("Cannot check for custom language (is the file missing?)", new Object[0]);
                return DEFAULT_FALLBACK_LANGUAGE;
            }
            try (InputStream inputStream = defaultLanguageFile.openStream();){
                Files.copy(inputStream, this.languageFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException exception) {
                Sonar.get0().getLogger().error("Error copying file: {}", exception);
                return DEFAULT_FALLBACK_LANGUAGE;
            }
        }
        try (FileInputStream input = new FileInputStream(this.languageFile);){
            Properties properties = new Properties();
            properties.load(input);
            String property = properties.getProperty("language");
            try {
                Language language = Language.fromCode(property);
                return language;
            }
            catch (Throwable throwable) {
                Sonar.get0().getLogger().error("Could not find requested language: {}", throwable);
                Sonar.get0().getLogger().error("You can view a full list of valid language codes here:", new Object[0]);
                Sonar.get0().getLogger().error("https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes", new Object[0]);
                Sonar.get0().getLogger().error("If a translation does not exist yet, Sonar will use English (en).", new Object[0]);
                ((InputStream)input).close();
            }
        }
        catch (IOException exception) {
            Sonar.get0().getLogger().error("Error reading language file: {}", exception);
        }
        return DEFAULT_FALLBACK_LANGUAGE;
    }

    public void load() {
        if (!this.pluginFolder.exists() && !this.pluginFolder.mkdirs()) {
            throw new IllegalStateException("Could not create plugin folder (insufficient permissions?)");
        }
        this.language = this.getPreferredLanguage();
        if (this.language == Language.SYSTEM) {
            try {
                String property = System.getProperty("user.language", "en");
                this.language = Language.fromCode(property);
                Sonar.get0().getLogger().info("Using system language ({}) for translations.", new Object[]{this.language});
            }
            catch (Exception exception) {
                Sonar.get0().getLogger().warn("Could not use system language for translations.", new Object[0]);
                Sonar.get0().getLogger().warn("Using default language ({}) for translations.", new Object[]{this.language});
            }
        } else {
            Sonar.get0().getLogger().info("Using custom language ({}) for translations.", new Object[]{this.language});
        }
        try {
            this.generalConfig.load(this.getAsset("config", this.language));
            this.messagesConfig.load(this.getAsset("messages", this.language));
            this.webhookConfig.load(this.getAsset("webhook", this.language));
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error loading configuration", exception);
        }
        this.loadValues();
    }

    public void loadValues() {
        this.logPlayerAddresses = this.generalConfig.getBoolean("general.log-player-addresses");
        this.maxOnlinePerIp = SonarConfiguration.clamp(this.generalConfig.getInt("general.max-online-per-ip"), -1, 99);
        this.minPlayersForAttack = SonarConfiguration.clamp(this.generalConfig.getInt("attack-tracker.min-players-for-attack"), 2, 1024);
        this.minAttackDuration = SonarConfiguration.clamp(this.generalConfig.getInt("attack-tracker.min-attack-duration"), 1000, 900000);
        this.minAttackThreshold = SonarConfiguration.clamp(this.generalConfig.getInt("attack-tracker.min-attack-threshold"), 0, 20);
        this.attackCooldownDelay = SonarConfiguration.clamp(this.generalConfig.getInt("attack-tracker.attack-cooldown-delay"), 100, 30000);
        this.database.type = Database.Type.valueOf(this.generalConfig.getString("database.type").toUpperCase());
        this.database.maximumAge = SonarConfiguration.clamp(this.generalConfig.getInt("database.maximum-age"), 1, 365);
        this.queue.maxQueuePolls = SonarConfiguration.clamp(this.generalConfig.getInt("queue.max-polls"), 1, 1000);
        this.verification.timing = Verification.Timing.valueOf(this.generalConfig.getString("verification.timing"));
        if (this.verification.timing == Verification.Timing.NEVER) {
            Sonar.get0().getLogger().warn(" ", new Object[0]);
            Sonar.get0().getLogger().warn("You have set the verification timing to 'NEVER'.", new Object[0]);
            Sonar.get0().getLogger().warn("Sonar will NOT perform the bot verification at all, therefore making it useless.", new Object[0]);
            Sonar.get0().getLogger().warn("It is highly suggested to set this option to either 'DURING_ATTACK' or 'ALWAYS'.", new Object[0]);
            Sonar.get0().getLogger().warn("Please only edit this option if you really know what you are doing.", new Object[0]);
            Sonar.get0().getLogger().warn(" ", new Object[0]);
        }
        this.verification.gravity.enabled = this.generalConfig.getBoolean("verification.checks.gravity.enabled");
        this.verification.gravity.checkCollisions = this.generalConfig.getBoolean("verification.checks.collision.enabled");
        this.verification.gravity.captchaOnFail = this.generalConfig.getBoolean("verification.checks.gravity.captcha-on-fail");
        this.verification.gravity.maxMovementTicks = SonarConfiguration.clamp(this.generalConfig.getInt("verification.checks.gravity.max-movement-ticks"), 2, 100);
        this.verification.vehicle.enabled = this.generalConfig.getBoolean("verification.checks.vehicle.enabled");
        this.verification.vehicle.minimumPackets = SonarConfiguration.clamp(this.generalConfig.getInt("verification.checks.vehicle.minimum-packets"), 0, 20);
        this.verification.map.timing = Verification.Timing.valueOf(this.generalConfig.getString("verification.checks.map-captcha.timing"));
        this.verification.map.precomputeAmount = SonarConfiguration.clamp(this.generalConfig.getInt("verification.checks.map-captcha.precompute"), 10, 5000);
        this.verification.map.maxDuration = SonarConfiguration.clamp(this.generalConfig.getInt("verification.checks.map-captcha.max-duration"), 5000, 360000);
        this.verification.map.maxTries = SonarConfiguration.clamp(this.generalConfig.getInt("verification.checks.map-captcha.max-tries"), 1, 100);
        this.verification.map.alphabet = this.generalConfig.getString("verification.checks.map-captcha.alphabet");
        this.verification.map.backgroundImage = null;
        String backgroundPath = this.generalConfig.getString("verification.checks.map-captcha.background");
        if (!backgroundPath.isEmpty()) {
            File backgroundFile = new File(this.pluginFolder, backgroundPath);
            if (backgroundFile.exists()) {
                this.verification.map.backgroundImage = backgroundFile;
            } else {
                Sonar.get0().getLogger().error("Could not find background image {}", backgroundFile.getAbsolutePath());
            }
        }
        this.verification.brand.enabled = this.generalConfig.getBoolean("verification.checks.client-brand.enabled");
        this.verification.brand.validRegex = Pattern.compile(this.generalConfig.getString("verification.checks.client-brand.valid-regex"));
        this.verification.brand.maxLength = this.generalConfig.getInt("verification.checks.client-brand.max-length");
        this.verification.timeOfDay = SonarConfiguration.clamp(this.generalConfig.getInt("verification.time-of-day"), 0, 24000);
        this.verification.gamemode = Verification.Gamemode.valueOf(this.generalConfig.getString("verification.gamemode"));
        this.verification.validNameRegex = Pattern.compile(this.generalConfig.getString("verification.checks.valid-name-regex"));
        this.verification.checkGeyser = this.generalConfig.getBoolean("verification.check-geyser-players");
        this.verification.logConnections = this.generalConfig.getBoolean("verification.log-connections");
        this.verification.logDuringAttack = this.generalConfig.getBoolean("verification.log-during-attack");
        this.verification.debugXYZPositions = this.generalConfig.getBoolean("verification.debug-xyz-positions");
        this.verification.readTimeout = SonarConfiguration.clamp(this.generalConfig.getInt("verification.read-timeout"), 1000, 30000);
        this.verification.writeTimeout = SonarConfiguration.clamp(this.generalConfig.getInt("verification.write-timeout"), 1000, 30000);
        this.verification.maxPacketCount = SonarConfiguration.clamp(this.generalConfig.getInt("verification.max-packets"), 200, 9999);
        this.verification.reconnectDelay = SonarConfiguration.clamp(this.generalConfig.getInt("verification.rejoin-delay"), 0, 100000);
        this.verification.rememberTime = SonarConfiguration.clamp(this.generalConfig.getInt("verification.remember-time"), 0, 86400000);
        this.verification.blacklistTime = SonarConfiguration.clamp(this.generalConfig.getInt("verification.blacklist-time"), 0, 86400000);
        this.verification.blacklistThreshold = SonarConfiguration.clamp(this.generalConfig.getInt("verification.blacklist-threshold"), 0, 100);
        this.verification.blacklistedProtocols.clear();
        this.verification.blacklistedProtocols.addAll(this.generalConfig.getIntList("verification.blacklisted-protocols"));
        this.webhook.url = this.webhookConfig.getString("webhook.url");
        this.webhook.username = this.webhookConfig.getString("webhook.username");
        this.webhook.avatarUrl = this.webhookConfig.getString("webhook.avatar-url");
        this.webhook.content = this.webhookConfig.getString("webhook.content");
        this.webhook.footer.text = this.webhookConfig.getString("webhook.embed.footer.text");
        this.webhook.footer.iconUrl = this.webhookConfig.getString("webhook.embed.footer.icon-url");
        this.webhook.embed.title = this.webhookConfig.getString("webhook.embed.title");
        this.webhook.embed.titleUrl = this.webhookConfig.getString("webhook.embed.title-url");
        this.webhook.embed.description = String.join((CharSequence)"\n", this.webhookConfig.getStringList("webhook.embed.description"));
        this.webhook.embed.r = this.webhookConfig.getInt("webhook.embed.color.red");
        this.webhook.embed.g = this.webhookConfig.getInt("webhook.embed.color.green");
        this.webhook.embed.b = this.webhookConfig.getInt("webhook.embed.color.blue");
        if (!this.webhook.url.isEmpty()) {
            if (this.webhook.username.isEmpty()) {
                throw new IllegalStateException("Webhook username cannot be empty");
            }
            this.webhook.discordWebhook = new DiscordWebhook(this.webhook.url);
        } else if (this.webhook.discordWebhook != null) {
            this.webhook.discordWebhook = null;
        }
        this.prefix = MiniMessage.miniMessage().deserialize((Object)this.messagesConfig.getString("prefix"));
        String noPermissionMessage = this.messagesConfig.getString("commands.no-permission");
        this.noPermission = noPermissionMessage.isEmpty() ? null : MiniMessage.miniMessage().deserialize(noPermissionMessage, (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)this.prefix));
        SonarCommand.prepareCachedTabSuggestions();
        this.supportUrl = this.messagesConfig.getString("support-url");
        this.header = MiniMessage.miniMessage().deserialize(String.join((CharSequence)"<newline>", this.messagesConfig.getStringList("header")), new TagResolver[]{Placeholder.unparsed((String)"support-url", (String)this.supportUrl), Placeholder.component((String)"prefix", (ComponentLike)this.prefix)});
        this.footer = MiniMessage.miniMessage().deserialize(String.join((CharSequence)"<newline>", this.messagesConfig.getStringList("footer")), new TagResolver[]{Placeholder.unparsed((String)"support-url", (String)this.supportUrl), Placeholder.component((String)"prefix", (ComponentLike)this.prefix)});
        this.tooManyOnlinePerIp = this.deserializeDisconnectMessage("too-many-online-per-ip");
        this.verification.currentlyPreparing = this.deserializeDisconnectMessage("verification.currently-preparing");
        this.verification.unsupportedVersion = this.deserializeDisconnectMessage("verification.unsupported-version");
        this.verification.tooFastReconnect = this.deserializeDisconnectMessage("verification.too-fast-reconnect");
        this.verification.alreadyVerifying = this.deserializeDisconnectMessage("verification.already-verifying");
        this.verification.alreadyQueued = this.deserializeDisconnectMessage("verification.already-queued");
        this.verification.blacklisted = this.deserializeDisconnectMessage("verification.blacklisted");
        this.verification.invalidUsername = this.deserializeDisconnectMessage("verification.invalid-username");
        this.verification.protocolBlacklisted = this.deserializeDisconnectMessage("verification.blacklisted-protocol");
        this.verification.verificationSuccess = this.deserializeDisconnectMessage("verification.success");
        this.verification.verificationFailed = this.deserializeDisconnectMessage("verification.failed");
        this.verboseAnimation = Collections.unmodifiableList(this.messagesConfig.getStringList("verbose.animation"));
    }

    @NotNull
    private Component deserializeDisconnectMessage(String path) {
        return MiniMessage.miniMessage().deserialize(String.join((CharSequence)"<newline>", this.messagesConfig.getStringList(path)), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)this.prefix), Placeholder.component((String)"header", (ComponentLike)this.header), Placeholder.component((String)"footer", (ComponentLike)this.footer), Placeholder.unparsed((String)"support-url", (String)this.supportUrl)});
    }

    @NotNull
    private URL getAsset(String url, @NotNull Language language) {
        String resourceName = url + "/" + language.getCode() + ".yml";
        URL result = Sonar.class.getResource("/assets/" + resourceName);
        if (result == null) {
            Sonar.get0().getLogger().warn("Could not find " + resourceName + "! Using en.yml!", new Object[0]);
            result = Objects.requireNonNull(Sonar.class.getResource("/assets/" + url + "/en.yml"));
        }
        return result;
    }

    private static int clamp(int v, int max, int min) {
        int output = Math.max(Math.min(v, min), max);
        if (output != v) {
            Sonar.get0().getLogger().warn("Clamped configuration value {} to {}", v, output);
        }
        return output;
    }

    @NotNull
    public String formatAddress(@NotNull InetAddress inetAddress) {
        return this.logPlayerAddresses ? inetAddress.getHostAddress() : "<ip address withheld>";
    }

    public SimpleYamlConfig getGeneralConfig() {
        return this.generalConfig;
    }

    public SimpleYamlConfig getMessagesConfig() {
        return this.messagesConfig;
    }

    public SimpleYamlConfig getWebhookConfig() {
        return this.webhookConfig;
    }

    public File getLanguageFile() {
        return this.languageFile;
    }

    public File getPluginFolder() {
        return this.pluginFolder;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public Verification getVerification() {
        return this.verification;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Webhook getWebhook() {
        return this.webhook;
    }

    public Component getPrefix() {
        return this.prefix;
    }

    public Component getNoPermission() {
        return this.noPermission;
    }

    public int getMaxOnlinePerIp() {
        return this.maxOnlinePerIp;
    }

    public int getMinPlayersForAttack() {
        return this.minPlayersForAttack;
    }

    public int getMinAttackDuration() {
        return this.minAttackDuration;
    }

    public int getMinAttackThreshold() {
        return this.minAttackThreshold;
    }

    public int getAttackCooldownDelay() {
        return this.attackCooldownDelay;
    }

    public Component getTooManyOnlinePerIp() {
        return this.tooManyOnlinePerIp;
    }

    public List<String> getVerboseAnimation() {
        return this.verboseAnimation;
    }

    public static final class Queue {
        private int maxQueuePolls;

        public int getMaxQueuePolls() {
            return this.maxQueuePolls;
        }

        private Queue() {
        }
    }

    public static final class Verification {
        private Timing timing;
        private final Map map = new Map();
        private final Gravity gravity = new Gravity();
        private final Vehicle vehicle = new Vehicle();
        private final Brand brand = new Brand();
        private Gamemode gamemode;
        private int timeOfDay;
        private boolean checkGeyser;
        private boolean logConnections;
        private boolean logDuringAttack;
        private boolean debugXYZPositions;
        private Pattern validNameRegex;
        private int readTimeout;
        private int writeTimeout;
        private int maxPacketCount;
        private int reconnectDelay;
        private int rememberTime;
        private int blacklistTime;
        private int blacklistThreshold;
        private final Collection<Integer> blacklistedProtocols = new HashSet<Integer>(0);
        private Component tooFastReconnect;
        private Component invalidUsername;
        private Component verificationSuccess;
        private Component verificationFailed;
        private Component alreadyVerifying;
        private Component alreadyQueued;
        private Component blacklisted;
        private Component protocolBlacklisted;
        private Component currentlyPreparing;
        private Component unsupportedVersion;

        public Timing getTiming() {
            return this.timing;
        }

        public Map getMap() {
            return this.map;
        }

        public Gravity getGravity() {
            return this.gravity;
        }

        public Vehicle getVehicle() {
            return this.vehicle;
        }

        public Brand getBrand() {
            return this.brand;
        }

        public Gamemode getGamemode() {
            return this.gamemode;
        }

        public int getTimeOfDay() {
            return this.timeOfDay;
        }

        public boolean isCheckGeyser() {
            return this.checkGeyser;
        }

        public boolean isLogConnections() {
            return this.logConnections;
        }

        public boolean isLogDuringAttack() {
            return this.logDuringAttack;
        }

        public boolean isDebugXYZPositions() {
            return this.debugXYZPositions;
        }

        public Pattern getValidNameRegex() {
            return this.validNameRegex;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public int getWriteTimeout() {
            return this.writeTimeout;
        }

        public int getMaxPacketCount() {
            return this.maxPacketCount;
        }

        public int getReconnectDelay() {
            return this.reconnectDelay;
        }

        public int getRememberTime() {
            return this.rememberTime;
        }

        public int getBlacklistTime() {
            return this.blacklistTime;
        }

        public int getBlacklistThreshold() {
            return this.blacklistThreshold;
        }

        public Collection<Integer> getBlacklistedProtocols() {
            return this.blacklistedProtocols;
        }

        public Component getTooFastReconnect() {
            return this.tooFastReconnect;
        }

        public Component getInvalidUsername() {
            return this.invalidUsername;
        }

        public Component getVerificationSuccess() {
            return this.verificationSuccess;
        }

        public Component getVerificationFailed() {
            return this.verificationFailed;
        }

        public Component getAlreadyVerifying() {
            return this.alreadyVerifying;
        }

        public Component getAlreadyQueued() {
            return this.alreadyQueued;
        }

        public Component getBlacklisted() {
            return this.blacklisted;
        }

        public Component getProtocolBlacklisted() {
            return this.protocolBlacklisted;
        }

        public Component getCurrentlyPreparing() {
            return this.currentlyPreparing;
        }

        public Component getUnsupportedVersion() {
            return this.unsupportedVersion;
        }

        private Verification() {
        }

        public static enum Timing {
            ALWAYS("Always"),
            DURING_ATTACK("During Attack"),
            NEVER("Never");

            private final String displayName;

            public String getDisplayName() {
                return this.displayName;
            }

            private Timing(String displayName) {
                this.displayName = displayName;
            }
        }

        public static final class Map {
            private Timing timing;
            private int precomputeAmount;
            private int maxDuration;
            private int maxTries;
            private String alphabet;
            private File backgroundImage;

            public Timing getTiming() {
                return this.timing;
            }

            public int getPrecomputeAmount() {
                return this.precomputeAmount;
            }

            public int getMaxDuration() {
                return this.maxDuration;
            }

            public int getMaxTries() {
                return this.maxTries;
            }

            public String getAlphabet() {
                return this.alphabet;
            }

            public File getBackgroundImage() {
                return this.backgroundImage;
            }
        }

        public static final class Gravity {
            private boolean enabled;
            private boolean checkCollisions;
            private boolean captchaOnFail;
            private int maxMovementTicks;

            public boolean isEnabled() {
                return this.enabled;
            }

            public boolean isCheckCollisions() {
                return this.checkCollisions;
            }

            public boolean isCaptchaOnFail() {
                return this.captchaOnFail;
            }

            public int getMaxMovementTicks() {
                return this.maxMovementTicks;
            }
        }

        public static final class Vehicle {
            private boolean enabled;
            private int minimumPackets;

            public boolean isEnabled() {
                return this.enabled;
            }

            public int getMinimumPackets() {
                return this.minimumPackets;
            }
        }

        public static final class Brand {
            private boolean enabled;
            private int maxLength;
            private Pattern validRegex;

            public boolean isEnabled() {
                return this.enabled;
            }

            public int getMaxLength() {
                return this.maxLength;
            }

            public Pattern getValidRegex() {
                return this.validRegex;
            }
        }

        public static enum Gamemode {
            NOT_SET(-1),
            SURVIVAL(0),
            CREATIVE(1),
            ADVENTURE(2);

            private final int id;

            public boolean isSurvivalOrAdventure() {
                return this == SURVIVAL || this == ADVENTURE;
            }

            public int getId() {
                return this.id;
            }

            private Gamemode(int id) {
                this.id = id;
            }
        }
    }

    public static final class Database {
        private Type type;
        private int maximumAge;

        public Type getType() {
            return this.type;
        }

        public int getMaximumAge() {
            return this.maximumAge;
        }

        private Database() {
        }

        public static enum Type {
            MYSQL("MySQL", "jdbc:mysql://%s:%d/%s%s", (DatabaseType)new MysqlDatabaseTypeAdapter(), Library.builder().groupId("com{}mysql").artifactId("mysql-connector-j").version("9.0.0").relocate("com{}mysql", "xyz{}jonesdev{}sonar{}libs{}mysql").build()),
            MARIADB("MariaDB", "jdbc:mariadb://%s:%d/%s%s", (DatabaseType)new MariaDbDatabaseTypeAdapter(), Library.builder().groupId("org{}mariadb{}jdbc").artifactId("mariadb-java-client").version("3.4.1").relocate("org{}mariadb", "xyz{}jonesdev{}sonar{}libs{}mariadb").build()),
            H2("H2", "jdbc:h2:file:%s", (DatabaseType)new H2DatabaseTypeAdapter(), Library.builder().groupId("com{}h2database").artifactId("h2").version("2.2.220").relocate("org{}h2", "xyz{}jonesdev{}sonar{}libs{}h2").build()),
            POSTGRESQL("PostgreSQL", "jdbc:postgresql://%s:%d/%s%s", (DatabaseType)new PostgresDatabaseTypeAdapter(), Library.builder().groupId("org{}postgresql").artifactId("postgresql").version("42.7.8").relocate("org{}postgresql", "xyz{}jonesdev{}sonar{}libs{}postgresql").build()),
            NONE("None", null, null, null);

            private final String displayName;
            private final String connectionString;
            private final DatabaseType databaseType;
            private final Library databaseDriver;
            private boolean loaded;

            public String getDisplayName() {
                return this.displayName;
            }

            public String getConnectionString() {
                return this.connectionString;
            }

            public DatabaseType getDatabaseType() {
                return this.databaseType;
            }

            public Library getDatabaseDriver() {
                return this.databaseDriver;
            }

            public boolean isLoaded() {
                return this.loaded;
            }

            private Type(String displayName, String connectionString, DatabaseType databaseType, Library databaseDriver) {
                this.displayName = displayName;
                this.connectionString = connectionString;
                this.databaseType = databaseType;
                this.databaseDriver = databaseDriver;
            }

            public void setLoaded(boolean loaded) {
                this.loaded = loaded;
            }
        }
    }

    public static final class Webhook {
        private String url;
        private String username;
        private String avatarUrl;
        private String content;
        private final Footer footer = new Footer();
        private final Embed embed = new Embed();
        @Nullable
        private DiscordWebhook discordWebhook;

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public String getContent() {
            return this.content;
        }

        public Footer getFooter() {
            return this.footer;
        }

        public Embed getEmbed() {
            return this.embed;
        }

        private Webhook() {
        }

        @Nullable
        public DiscordWebhook getDiscordWebhook() {
            return this.discordWebhook;
        }

        public static final class Footer {
            private String text;
            private String iconUrl;

            public String getText() {
                return this.text;
            }

            public String getIconUrl() {
                return this.iconUrl;
            }

            private Footer() {
            }
        }

        public static final class Embed {
            private String title;
            private String titleUrl;
            private String description;
            private int r;
            private int g;
            private int b;

            public String getTitle() {
                return this.title;
            }

            public String getTitleUrl() {
                return this.titleUrl;
            }

            public String getDescription() {
                return this.description;
            }

            public int getR() {
                return this.r;
            }

            public int getG() {
                return this.g;
            }

            public int getB() {
                return this.b;
            }

            public Embed() {
            }

            public Embed(String title, String titleUrl, String description, int r, int g, int b) {
                this.title = title;
                this.titleUrl = titleUrl;
                this.description = description;
                this.r = r;
                this.g = g;
                this.b = b;
            }

            public void setDescription(String description) {
                this.description = description;
            }
        }
    }
}

