/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.profiler;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;

public final class SimpleProcessProfiler {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final OperatingSystemMXBean MX = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private static final char[] MEMORY_UNITS = new char[]{'K', 'M', 'G', 'T', 'P', 'E'};
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#");

    public static String formatMemory(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        int group = (63 - Long.numberOfLeadingZeros(size)) / 10;
        double formattedSize = (double)size / (double)(1L << group * 10);
        char unit = MEMORY_UNITS[group - 1];
        return DECIMAL_FORMAT.format(formattedSize) + " " + unit + "iB";
    }

    public static int getVirtualCores() {
        return RUNTIME.availableProcessors();
    }

    public static double getProcessCPUUsage() {
        return MX.getProcessCpuLoad() * 100.0;
    }

    public static double getAverageProcessCPUUsage() {
        return SimpleProcessProfiler.getProcessCPUUsage() / (double)SimpleProcessProfiler.getVirtualCores();
    }

    public static double getSystemCPUUsage() {
        return MX.getSystemCpuLoad() * 100.0;
    }

    public static double getAverageSystemCPUUsage() {
        return SimpleProcessProfiler.getSystemCPUUsage() / (double)SimpleProcessProfiler.getVirtualCores();
    }

    public static long getMaxMemory() {
        return RUNTIME.maxMemory();
    }

    public static long getTotalMemory() {
        return RUNTIME.totalMemory();
    }

    public static long getFreeMemory() {
        return RUNTIME.freeMemory();
    }

    public static long getUsedMemory() {
        return SimpleProcessProfiler.getTotalMemory() - SimpleProcessProfiler.getFreeMemory();
    }

    private SimpleProcessProfiler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

