/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.webhook;

import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.config.SonarConfiguration;
import xyz.jonesdev.sonar.libs.gson.Gson;
import xyz.jonesdev.sonar.libs.gson.GsonBuilder;

public final class DiscordWebhook {
    private final String url;
    private static final Gson GSON = new GsonBuilder().create();
    private static final ExecutorService HTTP_REQUEST_SERVICE = Executors.newSingleThreadExecutor();

    public void post(Supplier<SonarConfiguration.Webhook.Embed> embed) {
        HTTP_REQUEST_SERVICE.execute(() -> {
            try {
                String serializedContent = DiscordWebhook.prepareSerializedContent((SonarConfiguration.Webhook.Embed)embed.get());
                HttpsURLConnection urlConnection = this.prepareConnection(new URL(this.url), serializedContent);
                try (OutputStream outputStream = urlConnection.getOutputStream();){
                    outputStream.write(serializedContent.getBytes(StandardCharsets.UTF_8));
                }
                int code = urlConnection.getResponseCode();
                if (code != 204) {
                    Sonar.get0().getLogger().warn("Unexpected Discord webhook response code {}", code);
                }
            }
            catch (Exception exception) {
                Sonar.get0().getLogger().error("Could not send webhook: {}", exception);
            }
        });
    }

    private static String prepareSerializedContent(@NotNull SonarConfiguration.Webhook.Embed embed) {
        String content = Sonar.get0().getConfig().getWebhook().getContent();
        String username = Sonar.get0().getConfig().getWebhook().getUsername();
        String avatarUrl = Sonar.get0().getConfig().getWebhook().getAvatarUrl();
        int rgb = embed.getR();
        rgb = (rgb << 8) + embed.getG();
        rgb = (rgb << 8) + embed.getB();
        Webhook.EmbedMessage embedMessage = new Webhook.EmbedMessage(embed.getTitle(), embed.getDescription(), embed.getTitleUrl(), rgb, new Webhook.Field[0], new Webhook.Footer(Sonar.get0().getConfig().getWebhook().getFooter().getText(), Sonar.get0().getConfig().getWebhook().getFooter().getIconUrl()));
        List<Webhook.EmbedMessage> embeds = Collections.singletonList(embedMessage);
        Webhook webhook = new Webhook(content, username, avatarUrl, false, embeds);
        return GSON.toJson((Object)webhook);
    }

    @NotNull
    private HttpsURLConnection prepareConnection(@NotNull URL url, @NotNull String serializedContent) throws Exception {
        HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
        urlConnection.setConnectTimeout(15000);
        urlConnection.setRequestProperty("Content-Type", "application/json");
        urlConnection.setRequestProperty("Content-Length", String.valueOf(serializedContent.length()));
        urlConnection.setRequestProperty("User-Agent", "Sonar");
        urlConnection.setDoOutput(true);
        urlConnection.setRequestMethod("POST");
        return urlConnection;
    }

    public DiscordWebhook(String url) {
        this.url = url;
    }

    static final class Webhook {
        private final String content;
        private final String username;
        private final String avatar_url;
        private final boolean tts;
        private final List<EmbedMessage> embeds;

        public Webhook(String content, String username, String avatar_url, boolean tts, List<EmbedMessage> embeds) {
            this.content = content;
            this.username = username;
            this.avatar_url = avatar_url;
            this.tts = tts;
            this.embeds = embeds;
        }

        static final class Footer {
            private final String text;
            private final String icon_url;

            public Footer(String text, String icon_url) {
                this.text = text;
                this.icon_url = icon_url;
            }
        }

        static final class Field {
            private final String name;
            private final String value;
            private final boolean inline;

            public Field(String name, String value, boolean inline) {
                this.name = name;
                this.value = value;
                this.inline = inline;
            }
        }

        static final class EmbedMessage {
            private final String title;
            private final String description;
            private final String url;
            private final int color;
            private final Field[] fields;
            private final Footer footer;

            public EmbedMessage(String title, String description, String url, int color, Field[] fields, Footer footer) {
                this.title = title;
                this.description = description;
                this.url = url;
                this.color = color;
                this.fields = fields;
                this.footer = footer;
            }
        }
    }
}

