/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.bukkit;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.SonarPlatform;
import xyz.jonesdev.sonar.api.logger.LoggerWrapper;
import xyz.jonesdev.sonar.bukkit.SonarBukkitPlugin;
import xyz.jonesdev.sonar.bukkit.command.BukkitSonarCommand;
import xyz.jonesdev.sonar.bukkit.fallback.FallbackBukkitInjector;
import xyz.jonesdev.sonar.bukkit.listener.BukkitJoinListener;
import xyz.jonesdev.sonar.common.boot.SonarBootstrap;
import xyz.jonesdev.sonar.libs.bstats.bukkit.Metrics;
import xyz.jonesdev.sonar.libs.bstats.charts.SimplePie;
import xyz.jonesdev.sonar.libs.kyori.adventure.audience.Audience;
import xyz.jonesdev.sonar.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import xyz.jonesdev.sonar.libs.libby.BukkitLibraryManager;

public final class SonarBukkit
extends SonarBootstrap<SonarBukkitPlugin> {
    private final BukkitAudiences bukkitAudiences = BukkitAudiences.create((Plugin)this.getPlugin());
    private final LoggerWrapper logger = new LoggerWrapper(){

        @Override
        public void info(String message, Object ... args) {
            ((SonarBukkitPlugin)((Object)SonarBukkit.this.getPlugin())).getLogger().info(this.buildFullMessage(message, args));
        }

        @Override
        public void warn(String message, Object ... args) {
            ((SonarBukkitPlugin)((Object)SonarBukkit.this.getPlugin())).getLogger().warning(this.buildFullMessage(message, args));
        }

        @Override
        public void error(String message, Object ... args) {
            ((SonarBukkitPlugin)((Object)SonarBukkit.this.getPlugin())).getLogger().severe(this.buildFullMessage(message, args));
        }
    };
    private Metrics metrics;
    public static final CompletableFuture<Void> INITIALIZE_LISTENER = new CompletableFuture();

    public SonarBukkit(@NotNull SonarBukkitPlugin plugin) {
        super(plugin, SonarPlatform.BUKKIT, plugin.getDataFolder(), new BukkitLibraryManager((Plugin)plugin));
    }

    @Override
    @Nullable
    public Audience audience(@Nullable UUID uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        return this.bukkitAudiences.player(uniqueId);
    }

    @Override
    @NotNull
    public Audience sender(@NotNull Object object) {
        return this.bukkitAudiences.sender((CommandSender)object);
    }

    @Override
    public void enable() {
        this.metrics = new Metrics((Plugin)this.getPlugin(), this.getPlatform().getMetricsId());
        this.metrics.addCustomChart(new SimplePie("verification", () -> this.getConfig().getVerification().getTiming().getDisplayName()));
        this.metrics.addCustomChart(new SimplePie("captcha", () -> this.getConfig().getVerification().getMap().getTiming().getDisplayName()));
        this.metrics.addCustomChart(new SimplePie("language", () -> this.getConfig().getLanguage().getName()));
        this.metrics.addCustomChart(new SimplePie("database_type", () -> this.getConfig().getDatabase().getType().getDisplayName()));
        Objects.requireNonNull(((SonarBukkitPlugin)((Object)this.getPlugin())).getCommand("sonar")).setExecutor((CommandExecutor)new BukkitSonarCommand());
        if (FallbackBukkitInjector.isLateBindEnabled()) {
            ((SonarBukkitPlugin)((Object)this.getPlugin())).getServer().getScheduler().runTask((Plugin)this.getPlugin(), FallbackBukkitInjector::inject);
        } else {
            ((SonarBukkitPlugin)((Object)this.getPlugin())).getServer().getPluginManager().registerEvents((Listener)new BukkitJoinListener(), (Plugin)this.getPlugin());
        }
        INITIALIZE_LISTENER.complete(null);
    }

    @Override
    public void disable() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    public BukkitAudiences getBukkitAudiences() {
        return this.bukkitAudiences;
    }

    @Override
    public LoggerWrapper getLogger() {
        return this.logger;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }
}

