/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.bukkit.fallback;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ChannelInactiveListener
extends ChannelInboundHandlerAdapter {
    private final Set<ChannelInboundHandler> handlers = new HashSet<ChannelInboundHandler>();

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        ProxiedChannelHandlerContext proxy = new ProxiedChannelHandlerContext(ctx);
        for (ChannelInboundHandler handler : this.handlers) {
            try {
                handler.channelInactive((ChannelHandlerContext)proxy);
            }
            catch (Exception exception) {
                handler.exceptionCaught((ChannelHandlerContext)proxy, (Throwable)exception);
            }
        }
        super.channelInactive(ctx);
    }

    public void add(@NotNull ChannelHandler channelHandler) {
        if (channelHandler instanceof ChannelInboundHandler) {
            this.handlers.add((ChannelInboundHandler)channelHandler);
        }
    }

    public static final class ProxiedChannelHandlerContext
    implements ChannelHandlerContext {
        private final ChannelHandlerContext ctx;

        public ChannelHandlerContext fireChannelInactive() {
            return this;
        }

        public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
            return this;
        }

        public Channel channel() {
            return this.ctx.channel();
        }

        public EventExecutor executor() {
            return this.ctx.executor();
        }

        public String name() {
            return this.ctx.name();
        }

        public ChannelHandler handler() {
            return this.ctx.handler();
        }

        public boolean isRemoved() {
            return this.ctx.isRemoved();
        }

        public ChannelHandlerContext fireChannelRegistered() {
            return this.ctx.fireChannelRegistered();
        }

        public ChannelHandlerContext fireChannelUnregistered() {
            return this.ctx.fireChannelUnregistered();
        }

        public ChannelHandlerContext fireChannelActive() {
            return this.ctx.fireChannelActive();
        }

        public ChannelHandlerContext fireUserEventTriggered(Object o) {
            return this.ctx.fireUserEventTriggered(o);
        }

        public ChannelHandlerContext fireChannelRead(Object o) {
            return this.ctx.fireChannelRead(o);
        }

        public ChannelHandlerContext fireChannelReadComplete() {
            return this.ctx.fireChannelReadComplete();
        }

        public ChannelHandlerContext fireChannelWritabilityChanged() {
            return this.ctx.fireChannelWritabilityChanged();
        }

        public ChannelFuture bind(SocketAddress socketAddress) {
            return this.ctx.bind(socketAddress);
        }

        public ChannelFuture connect(SocketAddress socketAddress) {
            return this.ctx.connect(socketAddress);
        }

        public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress1) {
            return this.ctx.connect(socketAddress, socketAddress1);
        }

        public ChannelFuture disconnect() {
            return this.ctx.disconnect();
        }

        public ChannelFuture close() {
            return this.ctx.close();
        }

        public ChannelFuture deregister() {
            return this.ctx.deregister();
        }

        public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
            return this.ctx.bind(socketAddress, channelPromise);
        }

        public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
            return this.ctx.connect(socketAddress, channelPromise);
        }

        public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress1, ChannelPromise channelPromise) {
            return this.ctx.connect(socketAddress, socketAddress1, channelPromise);
        }

        public ChannelFuture disconnect(ChannelPromise channelPromise) {
            return this.ctx.disconnect(channelPromise);
        }

        public ChannelFuture close(ChannelPromise channelPromise) {
            return this.ctx.close(channelPromise);
        }

        public ChannelFuture deregister(ChannelPromise channelPromise) {
            return this.ctx.deregister(channelPromise);
        }

        public ChannelHandlerContext read() {
            return this.ctx.read();
        }

        public ChannelFuture write(Object o) {
            return this.ctx.write(o);
        }

        public ChannelFuture write(Object o, ChannelPromise channelPromise) {
            return this.ctx.write(o, channelPromise);
        }

        public ChannelHandlerContext flush() {
            return this.ctx.flush();
        }

        public ChannelFuture writeAndFlush(Object o, ChannelPromise channelPromise) {
            return this.ctx.writeAndFlush(o, channelPromise);
        }

        public ChannelFuture writeAndFlush(Object o) {
            return this.ctx.writeAndFlush(o);
        }

        public ChannelPromise newPromise() {
            return this.ctx.newPromise();
        }

        public ChannelProgressivePromise newProgressivePromise() {
            return this.ctx.newProgressivePromise();
        }

        public ChannelFuture newSucceededFuture() {
            return this.ctx.newSucceededFuture();
        }

        public ChannelFuture newFailedFuture(Throwable throwable) {
            return this.ctx.newFailedFuture(throwable);
        }

        public ChannelPromise voidPromise() {
            return this.ctx.voidPromise();
        }

        public ChannelPipeline pipeline() {
            return this.ctx.pipeline();
        }

        public ByteBufAllocator alloc() {
            return this.ctx.alloc();
        }

        @Deprecated
        public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
            return this.ctx.attr(attributeKey);
        }

        @Deprecated
        public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
            return this.ctx.hasAttr(attributeKey);
        }

        private ProxiedChannelHandlerContext(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }
    }
}

