/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.bukkit.fallback;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.bukkit.fallback.ChannelInactiveListener;
import xyz.jonesdev.sonar.common.fallback.FallbackInboundHandlerAdapter;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketRegistry;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.handshake.HandshakePacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.login.LoginStartPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

final class FallbackBukkitInboundHandler
extends FallbackInboundHandlerAdapter {
    private static final ProtocolVersion DEFAULT_PROTOCOL_VERSION = ProtocolVersion.MINECRAFT_1_7_2;
    private FallbackPacketRegistry.ProtocolRegistry registry;

    FallbackBukkitInboundHandler() {
        this.updateRegistry(FallbackPacketRegistry.HANDSHAKE, DEFAULT_PROTOCOL_VERSION);
        this.channelRemovalListener = (pipeline, name, handler) -> {
            ChannelInactiveListener inactiveListener = (ChannelInactiveListener)pipeline.get(ChannelInactiveListener.class);
            if (inactiveListener != null) {
                inactiveListener.add(handler);
            }
        };
    }

    public void updateRegistry(@NotNull FallbackPacketRegistry registry, @NotNull ProtocolVersion protocolVersion) {
        this.registry = registry.getProtocolRegistry(FallbackPacketRegistry.Direction.SERVERBOUND, protocolVersion);
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)msg;
            int originalReaderIndex = byteBuf.readerIndex();
            byteBuf.readerIndex(0);
            if (!ctx.channel().isActive() || !byteBuf.isReadable()) {
                byteBuf.release();
                return;
            }
            int packetId = ProtocolUtil.readVarInt(byteBuf);
            FallbackPacket packet = this.registry.createPacket(packetId);
            if (packet == null) {
                byteBuf.release();
                return;
            }
            try {
                packet.decode(byteBuf, this.protocolVersion == null ? DEFAULT_PROTOCOL_VERSION : this.protocolVersion);
            }
            catch (Throwable throwable) {
                byteBuf.release();
                throw ProtocolUtil.DEBUG ? new DecoderException(throwable) : QuietDecoderException.INSTANCE;
            }
            if (byteBuf.isReadable()) {
                byteBuf.release();
                throw ProtocolUtil.DEBUG ? new DecoderException("Could not read packet to end (" + byteBuf.readableBytes() + " bytes left)") : QuietDecoderException.INSTANCE;
            }
            if (packet instanceof HandshakePacket) {
                HandshakePacket handshake = (HandshakePacket)packet;
                switch (handshake.getIntent()) {
                    case 1: {
                        ctx.pipeline().remove((ChannelHandler)this);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.handleHandshake(ctx, handshake.getHostname(), handshake.getProtocolVersionId());
                        this.updateRegistry(FallbackPacketRegistry.LOGIN, Objects.requireNonNull(this.protocolVersion));
                        break;
                    }
                    default: {
                        byteBuf.release();
                        throw ProtocolUtil.DEBUG ? new DecoderException("Bad handshake intent " + handshake.getIntent()) : QuietDecoderException.INSTANCE;
                    }
                }
            } else if (packet instanceof LoginStartPacket) {
                LoginStartPacket loginStart = (LoginStartPacket)packet;
                InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
                ctx.pipeline().remove((ChannelHandler)this);
                this.handleLogin(ctx, () -> {
                    byteBuf.readerIndex(originalReaderIndex);
                    ctx.fireChannelRead((Object)byteBuf.retain());
                    ChannelHandler inboundHandler = ctx.pipeline().remove("sonar-inbound-handler");
                    if (inboundHandler != null && this.channelRemovalListener != null) {
                        this.channelRemovalListener.accept(ctx.pipeline(), "sonar-inbound-handler", inboundHandler);
                    }
                }, loginStart.getUsername(), socketAddress);
                byteBuf.release();
                return;
            }
            byteBuf.readerIndex(originalReaderIndex);
            ctx.fireChannelRead((Object)byteBuf);
        } else {
            ctx.fireChannelRead(msg);
        }
    }
}

