/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.bukkit.fallback;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.bukkit.SonarBukkit;
import xyz.jonesdev.sonar.bukkit.fallback.BukkitServerVersion;
import xyz.jonesdev.sonar.bukkit.fallback.ChannelInactiveListener;
import xyz.jonesdev.sonar.bukkit.fallback.FallbackBukkitInboundHandler;
import xyz.jonesdev.sonar.common.fallback.netty.FallbackInjectedChannelInitializer;
import xyz.jonesdev.sonar.common.util.exception.ReflectiveOperationException;

public final class FallbackBukkitInjector {
    private static final String LEGACY_NMS_PACKAGE;
    private static final String OBC_PACKAGE;
    private static final BukkitServerVersion SERVER_VERSION;
    private static final boolean USES_LEGACY_PACKAGING;
    private static final boolean OBFUSCATED;
    private static final Class<?> MINECRAFT_SERVER_CLASS;
    private static final Class<?> CRAFTBUKKIT_SERVER_CLASS;
    private static final Class<?> SERVER_CONNECTION_CLASS;
    private static final Object SERVER_INSTANCE;
    private static boolean lateBindEnabled;

    private static void checkLateBind() {
        try {
            try {
                Class.forName("org.bukkit.event.server.ServerLoadEvent");
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class<?> spigotConfiguration = Class.forName("org.spigotmc.SpigotConfig");
                Method initFieldMethod = spigotConfiguration.getDeclaredMethod("lateBind", new Class[0]);
                initFieldMethod.setAccessible(true);
                initFieldMethod.invoke(null, new Object[0]);
                if (((Boolean)spigotConfiguration.getField("lateBind").get(null)).booleanValue()) {
                    lateBindEnabled = true;
                }
            }
        }
        catch (java.lang.ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    @NotNull
    public static Field getFieldAt(@NotNull Class<?> clazz, @NotNull Class<?> type, int index) {
        int currentIndex = 0;
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (!type.isAssignableFrom(field.getType()) || currentIndex++ != index) continue;
            return field;
        }
        if (clazz.getSuperclass() != null) {
            return FallbackBukkitInjector.getFieldAt(clazz.getSuperclass(), type, index);
        }
        throw new IllegalStateException("Could not find field #" + index + " in " + clazz.getName());
    }

    @NotNull
    public static Field findField(boolean checkSuperClass, @NotNull Class<?> clazz, String ... types) throws NoSuchFieldException {
        for (Field field : clazz.getDeclaredFields()) {
            String fieldTypeName = field.getType().getSimpleName();
            for (String type : types) {
                if (!fieldTypeName.equals(type)) continue;
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                return field;
            }
        }
        if (checkSuperClass && clazz != Object.class && clazz.getSuperclass() != null) {
            return FallbackBukkitInjector.findField(true, clazz.getSuperclass(), types);
        }
        throw new NoSuchFieldException(types[0]);
    }

    @NotNull
    private static BukkitServerVersion resolveServerVersion() {
        String bukkitVersion = Bukkit.getBukkitVersion();
        for (BukkitServerVersion serverVersion : BukkitServerVersion.REVERSED_VALUES) {
            if (!bukkitVersion.contains(serverVersion.getRelease())) continue;
            return serverVersion;
        }
        throw new IllegalStateException("Could not find server version " + bukkitVersion);
    }

    private static boolean isObfuscated() {
        try {
            Class.forName("net.minecraft.server.network.PlayerConnection");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    @NotNull
    private static Class<?> getNMSClass(String modern, String legacy) throws ClassNotFoundException {
        return Class.forName(USES_LEGACY_PACKAGING ? LEGACY_NMS_PACKAGE + legacy : "net.minecraft." + modern);
    }

    @NotNull
    public static Class<?> getOBCClass(String clazz) throws ClassNotFoundException {
        return Class.forName(OBC_PACKAGE + clazz);
    }

    public static void inject() {
        try {
            for (int i = 0; i < 2; ++i) {
                Field field = FallbackBukkitInjector.getFieldAt(SERVER_CONNECTION_CLASS, List.class, i);
                if (!field.getGenericType().getTypeName().contains(ChannelFuture.class.getName())) continue;
                List list = (List)field.get(FallbackBukkitInjector.getFieldAt(MINECRAFT_SERVER_CLASS, SERVER_CONNECTION_CLASS, 0).get(SERVER_INSTANCE));
                for (Object object : list) {
                    ChannelFuture channelFuture = (ChannelFuture)object;
                    List names = channelFuture.channel().pipeline().names();
                    ChannelHandler bootstrap = null;
                    for (String name : names) {
                        try {
                            ChannelHandler handler = channelFuture.channel().pipeline().get(name);
                            Field childHandlerField = handler.getClass().getDeclaredField("childHandler");
                            childHandlerField.setAccessible(true);
                            ChannelInitializer childHandler = (ChannelInitializer)childHandlerField.get(handler);
                            if (childHandler == null) break;
                            bootstrap = handler;
                            break;
                        }
                        catch (Exception handler) {
                        }
                    }
                    if (bootstrap == null) {
                        bootstrap = channelFuture.channel().pipeline().first();
                    }
                    Field childHandlerField = bootstrap.getClass().getDeclaredField("childHandler");
                    childHandlerField.setAccessible(true);
                    ChannelInitializer originalInitializer = (ChannelInitializer)childHandlerField.get(bootstrap);
                    if (!SonarBukkit.INITIALIZE_LISTENER.isDone()) {
                        childHandlerField.set(bootstrap, new ChannelInitializer<Channel>(){

                            protected void initChannel(@NotNull Channel channel) {
                                channel.close();
                            }
                        });
                    }
                    ChannelHandler _bootstrap = bootstrap;
                    SonarBukkit.INITIALIZE_LISTENER.thenAccept(__ -> {
                        try {
                            childHandlerField.set(_bootstrap, (Object)new FallbackInjectedChannelInitializer((ChannelInitializer<Channel>)originalInitializer, pipeline -> {
                                pipeline.addAfter("splitter", "sonar-packet-decoder", (ChannelHandler)new FallbackBukkitInboundHandler());
                                pipeline.addFirst("sonar-inactive-listener", (ChannelHandler)new ChannelInactiveListener());
                            }));
                        }
                        catch (IllegalAccessException exception) {
                            throw new ReflectiveOperationException(exception);
                        }
                    });
                }
                return;
            }
        }
        catch (Exception exception) {
            Sonar.get0().getLogger().error("An error occurred while injecting {}", exception);
        }
    }

    private FallbackBukkitInjector() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static boolean isLateBindEnabled() {
        return lateBindEnabled;
    }

    static {
        SERVER_VERSION = FallbackBukkitInjector.resolveServerVersion();
        USES_LEGACY_PACKAGING = SERVER_VERSION.compareTo(BukkitServerVersion.MINECRAFT_1_17) < 0;
        try {
            Object minecraftServerInstance;
            String bukkitPackage = Bukkit.getServer().getClass().getPackage().getName();
            String modifiedPackageName = SERVER_VERSION.compareTo(BukkitServerVersion.MINECRAFT_1_20_5) >= 0 ? bukkitPackage.split("\\.")[2] : bukkitPackage.split("\\.")[3];
            LEGACY_NMS_PACKAGE = "net.minecraft.server." + modifiedPackageName + ".";
            OBC_PACKAGE = bukkitPackage + ".";
            OBFUSCATED = FallbackBukkitInjector.isObfuscated();
            MINECRAFT_SERVER_CLASS = FallbackBukkitInjector.getNMSClass("server.MinecraftServer", "MinecraftServer");
            SERVER_CONNECTION_CLASS = FallbackBukkitInjector.getNMSClass(OBFUSCATED ? "server.network.ServerConnection" : "server.network.ServerConnectionListener", "ServerConnection");
            CRAFTBUKKIT_SERVER_CLASS = FallbackBukkitInjector.getOBCClass("CraftServer");
            try {
                minecraftServerInstance = FallbackBukkitInjector.getFieldAt(MINECRAFT_SERVER_CLASS, MINECRAFT_SERVER_CLASS, 0).get(null);
            }
            catch (Exception exception) {
                minecraftServerInstance = FallbackBukkitInjector.getFieldAt(CRAFTBUKKIT_SERVER_CLASS, MINECRAFT_SERVER_CLASS, 0).get(Bukkit.getServer());
            }
            SERVER_INSTANCE = minecraftServerInstance;
            FallbackBukkitInjector.checkLateBind();
        }
        catch (Exception exception) {
            throw new ReflectiveOperationException(exception);
        }
    }
}

