/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.captcha.filters;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public final class CurvesOverlayFilter {
    private final int amount;
    private static final Random RANDOM = new Random();

    public void transform(@NotNull BufferedImage image, @NotNull Graphics2D graphics) {
        graphics.setStroke(new BasicStroke(1.0f + RANDOM.nextFloat()));
        int halfWidth = image.getWidth() / 2;
        for (int i = 0; i < this.amount; ++i) {
            float randomX = (float)image.getWidth() * RANDOM.nextFloat();
            float randomY = (float)image.getHeight() * RANDOM.nextFloat();
            float amplitude = (float)Math.PI * 2 * (RANDOM.nextFloat() - 0.5f);
            float sin = (float)Math.sin(amplitude) * (float)halfWidth;
            float cos = (float)Math.cos(amplitude) * (float)halfWidth;
            float x1 = randomX - cos;
            float y1 = randomY - sin;
            float x2 = randomX + cos;
            float y2 = randomY + sin;
            float ctrlX1 = randomX + sin / 2.0f;
            float ctrlY1 = randomY - cos / 2.0f;
            float ctrlX2 = randomX - sin / 2.0f;
            float ctrlY2 = randomY + cos / 2.0f;
            graphics.draw(new CubicCurve2D.Float(x1, y1, ctrlX1, ctrlY1, ctrlX2, ctrlY2, x2, y2));
        }
    }

    public int getAmount() {
        return this.amount;
    }

    public CurvesOverlayFilter(int amount) {
        this.amount = amount;
    }
}

