/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.captcha.filters;

import java.awt.image.BufferedImage;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public final class NoiseOverlayFilter {
    private final float density;
    private final float amount;
    private static final Random RANDOM = new Random();

    private int randomGaussian(int x) {
        return Math.max(Math.min(x += (int)(RANDOM.nextGaussian() * (double)this.amount), 255), 0);
    }

    public void transform(@NotNull BufferedImage image) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                if (!(RANDOM.nextFloat() <= this.density)) continue;
                int rgb = image.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                r = this.randomGaussian(r);
                g = this.randomGaussian(g);
                b = this.randomGaussian(b);
                image.setRGB(x, y, r << 16 | g << 8 | b);
            }
        }
    }

    public float getDensity() {
        return this.density;
    }

    public float getAmount() {
        return this.amount;
    }

    public NoiseOverlayFilter(float density, float amount) {
        this.density = density;
        this.amount = amount;
    }
}

