/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.common.statistics.GlobalSonarStatistics;

@ChannelHandler.Sharable
public final class FallbackBandwidthHandler
extends ChannelDuplexHandler {
    public static final ChannelHandler INSTANCE = new FallbackBandwidthHandler();

    public void channelRead(ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            int readableBytes = ((ByteBuf)msg).readableBytes();
            GlobalSonarStatistics.perSecondIncomingTraffic += (long)readableBytes;
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            int readableBytes = ((ByteBuf)msg).readableBytes();
            GlobalSonarStatistics.perSecondOutgoingTraffic += (long)readableBytes;
        }
        ctx.write(msg, promise);
    }

    private FallbackBandwidthHandler() {
    }
}

