/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketRegistry;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketSnapshot;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class FallbackPacketEncoder
extends MessageToByteEncoder<FallbackPacket> {
    private final ProtocolVersion protocolVersion;
    private FallbackPacketRegistry packetRegistry;
    private FallbackPacketRegistry.ProtocolRegistry protocolRegistry;

    public void updateRegistry(@NotNull FallbackPacketRegistry packetRegistry) {
        this.packetRegistry = packetRegistry;
        this.protocolRegistry = packetRegistry.getProtocolRegistry(FallbackPacketRegistry.Direction.CLIENTBOUND, this.protocolVersion);
    }

    protected void encode(ChannelHandlerContext ctx, @NotNull FallbackPacket packet, @NotNull ByteBuf out) throws Exception {
        Class<Object> originalPacket = packet instanceof FallbackPacketSnapshot ? ((FallbackPacketSnapshot)packet).getOriginalPacketClass() : packet.getClass();
        int packetId = this.protocolRegistry.getPacketId(originalPacket);
        ProtocolUtil.writeVarInt(out, packetId);
        packet.encode(out, this.protocolVersion);
    }

    public FallbackPacketEncoder(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public FallbackPacketRegistry getPacketRegistry() {
        return this.packetRegistry;
    }
}

