/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.map;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public final class MapColorPalette {
    public static final int[] COLOR_MAP = new int[]{-1, -1, -1, -1, -10912473, -9594576, -8408520, -12362211, -5331853, -2766452, -530013, -8225962, -7566196, -5526613, -3684409, -9868951, -4980736, -2359296, -65536, -7929856, -9408332, -7697700, -6250241, -11250553, -9079435, -7303024, -5789785, -10987432, -16754944, -16750080, -16745472, -16760576, -4934476, -2302756, -1, -7895161, -9210239, -7499618, -5986120, -11118495, -9810890, -8233406, -6853299, -11585240, -11579569, -10461088, -9408400, -12895429, -13816396, -13158436, -12566273, -14605945, -10202062, -8690114, -7375032, -11845850, -4935252, -2303533, -779, -7895679, -6792924, -4559572, -2588877, -9288933, -8571496, -6733382, -5092136, -10606478, -12030824, -10976070, -10053160, -13217422, -6184668, -3816148, -1710797, -8816357, -10907631, -9588715, -8401895, -12358643, -5613196, -3117682, -884827, -8371369, -13290187, -12500671, -11776948, -14145496, -9671572, -8092540, -6710887, -11447983, -13280916, -12489340, -11763815, -14138543, -10933123, -9619815, -8437838, -12377762, -14404227, -13876839, -13415246, -14997410, -12045020, -10993364, -10073037, -13228005, -12035804, -10982100, -10059981, -13221093, -9690076, -8115156, -6737101, -11461861, -15658735, -15395563, -15132391, -15921907, -5199818, -2634430, -332211, -8094168, -12543338, -11551561, -10691627, -13601936, -13346124, -12620068, -11894529, -14204025, -16738008, -16729294, -16721606, -16748002, -10798046, -9483734, -8301007, -12309223, -11599616, -10485504, -9436672, -12910336};

    public static byte[] imageToBuffer(@NotNull BufferedImage bufferedImage) {
        byte[] buffer = new byte[16384];
        MapColorPalette.writeRGBBuffer(bufferedImage, buffer);
        return buffer;
    }

    private static void writeRGBBuffer(@NotNull BufferedImage bufferedImage, byte @NotNull [] rgbArray) {
        WritableRaster raster = bufferedImage.getRaster();
        byte[] data = new byte[raster.getNumBands()];
        int yoff = 0;
        int y = 0;
        while (y < raster.getHeight()) {
            int off = yoff;
            for (int x = 0; x < raster.getWidth(); ++x) {
                int rgb = bufferedImage.getColorModel().getRGB(raster.getDataElements(x, y, data));
                rgbArray[off++] = MapColorPalette.rgbToNearestMinecraft(rgb);
            }
            ++y;
            yoff += raster.getWidth();
        }
    }

    private static byte rgbToNearestMinecraft(int rgb) {
        int minDistance = Integer.MAX_VALUE;
        int closestIndex = 0;
        for (int i = 0; i < COLOR_MAP.length; ++i) {
            byte index = (byte)(i < 128 ? i : -129 + (i - 127));
            int distance = MapColorPalette.calculateColorDistance(rgb, COLOR_MAP[i]);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestIndex = index;
        }
        if (closestIndex > -1 && closestIndex < 3) {
            closestIndex = 34;
        }
        return (byte)closestIndex;
    }

    private static int calculateColorDistance(int rgb0, int rgb1) {
        int red0 = rgb0 >> 16 & 0xFF;
        int green0 = rgb0 >> 8 & 0xFF;
        int blue0 = rgb0 & 0xFF;
        int red1 = rgb1 >> 16 & 0xFF;
        int green1 = rgb1 >> 8 & 0xFF;
        int blue1 = rgb1 & 0xFF;
        return (red0 - red1) * (red0 - red1) + (green0 - green1) * (green0 - green1) + (blue0 - blue1) * (blue0 - blue1);
    }

    private MapColorPalette() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

