/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class AnimationPacket
implements FallbackPacket {
    private int entityId = -1;
    private int hand = 0;
    private LegacyAnimationType type = LegacyAnimationType.SWING_ARM;
    public static final int MAIN_HAND = 0;

    @Override
    public void encode(ByteBuf byteBuf, ProtocolVersion protocolVersion) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.entityId = byteBuf.readInt();
            this.type = LegacyAnimationType.getById(byteBuf.readByte());
        } else if (protocolVersion.greaterThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.hand = ProtocolUtil.readVarInt(byteBuf);
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getHand() {
        return this.hand;
    }

    public LegacyAnimationType getType() {
        return this.type;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setHand(int hand) {
        this.hand = hand;
    }

    public void setType(LegacyAnimationType type) {
        this.type = type;
    }

    public AnimationPacket() {
    }

    public AnimationPacket(int entityId, int hand, LegacyAnimationType type) {
        this.entityId = entityId;
        this.hand = hand;
        this.type = type;
    }

    public String toString() {
        return "AnimationPacket(entityId=" + this.getEntityId() + ", hand=" + this.getHand() + ")";
    }

    public static enum LegacyAnimationType {
        NO_ANIMATION,
        SWING_ARM,
        DAMAGE_ANIMATION,
        LEAVE_BED,
        EAT_FOOD,
        CRITICAL_EFFECT,
        MAGIC_CRITICAL_EFFECT,
        UNKNOWN(102),
        CROUCH(104),
        UNCROUCH(105);

        private final int id;

        private LegacyAnimationType(int id) {
            this.id = id;
        }

        private LegacyAnimationType() {
            this.id = this.ordinal();
        }

        public static LegacyAnimationType getById(int id) {
            if (id >= 0 && id <= 7) {
                return LegacyAnimationType.values()[id];
            }
            switch (id) {
                case 102: {
                    return UNKNOWN;
                }
                case 104: {
                    return CROUCH;
                }
                case 105: {
                    return UNCROUCH;
                }
            }
            throw new IllegalArgumentException("Unknown type with id: " + id);
        }

        public int getId() {
            return this.id;
        }
    }
}

