/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

public final class PluginMessagePacket
implements FallbackPacket {
    private String channel;
    private byte[] data;
    private static final int FORGE_MAX_ARRAY_LENGTH = 2097050;

    @Override
    public void encode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        int length;
        this.channel = ProtocolUtil.readString(byteBuf, 48);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_8) ? (length = byteBuf.readableBytes()) > Short.MAX_VALUE : (length = ProtocolUtil.readExtendedForgeShort(byteBuf)) > 2097050) {
            throw QuietDecoderException.INSTANCE;
        }
        this.data = new byte[length];
        byteBuf.readBytes(this.data);
    }

    @Override
    public int expectedMinLength(ProtocolVersion protocolVersion) {
        return 4;
    }

    @Override
    public int expectedMaxLength(ProtocolVersion protocolVersion) {
        return Short.MAX_VALUE;
    }

    public String getChannel() {
        return this.channel;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "PluginMessagePacket(channel=" + this.getChannel() + ", data=" + Arrays.toString(this.getData()) + ")";
    }
}

