/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class SetPassengersPacket
implements FallbackPacket {
    private int entityId;
    private int passengerId;

    @Override
    public void encode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.lessThanOrEquals(ProtocolVersion.MINECRAFT_1_8)) {
            byteBuf.writeInt(this.passengerId);
            byteBuf.writeInt(this.entityId);
            byteBuf.writeByte(0);
            return;
        }
        ProtocolUtil.writeVarInt(byteBuf, this.entityId);
        ProtocolUtil.writeVarInt(byteBuf, 1);
        ProtocolUtil.writeVarInt(byteBuf, this.passengerId);
    }

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getPassengerId() {
        return this.passengerId;
    }

    public String toString() {
        return "SetPassengersPacket(entityId=" + this.getEntityId() + ", passengerId=" + this.getPassengerId() + ")";
    }

    public SetPassengersPacket() {
    }

    public SetPassengersPacket(int entityId, int passengerId) {
        this.entityId = entityId;
        this.passengerId = passengerId;
    }
}

