/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.subcommand;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.SonarPlatform;
import xyz.jonesdev.sonar.api.command.InvocationSource;
import xyz.jonesdev.sonar.api.command.subcommand.Subcommand;
import xyz.jonesdev.sonar.api.command.subcommand.SubcommandInfo;
import xyz.jonesdev.sonar.api.profiler.SimpleProcessProfiler;
import xyz.jonesdev.sonar.libs.gson.Gson;
import xyz.jonesdev.sonar.libs.gson.GsonBuilder;

@SubcommandInfo(name="dump", onlyConsole=true)
public final class DumpCommand
extends Subcommand {
    private static final RuntimeMXBean RUNTIME_MX_BEAN = ManagementFactory.getRuntimeMXBean();
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    protected void execute(@NotNull InvocationSource source, String @NotNull [] args) {
        WeakHashMap<String, Object> mappings = new WeakHashMap<String, Object>();
        mappings.put("sonar", new Dump.Sonar(Sonar.get0().getVersion().getFormatted(), Sonar.get0().getPlatform(), Sonar.get0().getVersion().getGitBranch(), Sonar.get0().getVersion().getGitCommit()));
        mappings.put("runtime", new Dump.Runtime(SimpleProcessProfiler.getVirtualCores(), RUNTIME_MX_BEAN.getInputArguments(), RUNTIME_MX_BEAN.getVmName(), RUNTIME_MX_BEAN.getVmVendor(), RUNTIME_MX_BEAN.getVmVersion()));
        mappings.put("os", new Dump.OS(System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")));
        mappings.put("memory", new Dump.Memory(SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getTotalMemory()), SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getMaxMemory()), SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getFreeMemory()), SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getUsedMemory())));
        Sonar.get0().getLogger().info(Sonar.get0().getConfig().getMessagesConfig().getString("commands.dump.log").replace("<dumped-json-data>", GSON.toJson(mappings)), new Object[0]);
    }

    private static final class Dump {
        private Dump() {
        }

        private static final class OS {
            private final String name;
            private final String arch;
            private final String version;

            public OS(String name, String arch, String version) {
                this.name = name;
                this.arch = arch;
                this.version = version;
            }
        }

        private static final class Memory {
            private final String total;
            private final String max;
            private final String free;
            private final String used;

            public Memory(String total, String max, String free, String used) {
                this.total = total;
                this.max = max;
                this.free = free;
                this.used = used;
            }
        }

        private static final class Runtime {
            private final int virtualCores;
            private final List<String> jvmArguments;
            private final String vmName;
            private final String vmVendor;
            private final String vmVersion;

            public Runtime(int virtualCores, List<String> jvmArguments, String vmName, String vmVendor, String vmVersion) {
                this.virtualCores = virtualCores;
                this.jvmArguments = jvmArguments;
                this.vmName = vmName;
                this.vmVendor = vmVendor;
                this.vmVersion = vmVersion;
            }
        }

        private static final class Sonar {
            private final String version;
            private final SonarPlatform platform;
            private final String gitBranch;
            private final String gitCommit;

            public Sonar(String version, SonarPlatform platform, String gitBranch, String gitCommit) {
                this.version = version;
                this.platform = platform;
                this.gitBranch = gitBranch;
                this.gitCommit = gitCommit;
            }
        }
    }
}

